/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.resources;

import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import javax.security.auth.Subject;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.global.GlobalAuthorizationConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.rest.InvocationHelper;
import org.infinispan.rest.NettyRestResponse;
import org.infinispan.rest.cachemanager.RestCacheManager;
import org.infinispan.rest.framework.Method;
import org.infinispan.rest.framework.ResourceHandler;
import org.infinispan.rest.framework.RestRequest;
import org.infinispan.rest.framework.RestResponse;
import org.infinispan.rest.framework.impl.Invocations;
import org.infinispan.rest.logging.Log;
import org.infinispan.rest.resources.ResourceUtil;
import org.infinispan.rest.resources.SecurityActions;
import org.infinispan.security.AuditContext;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.GlobalSecurityManager;
import org.infinispan.security.MutablePrincipalRoleMapper;
import org.infinispan.security.MutableRolePermissionMapper;
import org.infinispan.security.PrincipalRoleMapper;
import org.infinispan.security.Role;
import org.infinispan.security.RolePermissionMapper;
import org.infinispan.security.impl.Authorizer;
import org.infinispan.security.impl.CacheRoleImpl;
import org.infinispan.security.impl.SubjectACL;
import org.infinispan.server.core.ProtocolServer;

public class SecurityResource
implements ResourceHandler {
    private final InvocationHelper invocationHelper;
    private final String accessGrantedPath;
    private final String accessDeniedPath;
    private final MutablePrincipalRoleMapper principalRoleMapper;
    private final MutableRolePermissionMapper rolePermissionMapper;

    public SecurityResource(InvocationHelper invocationHelper, String accessGrantedPath, String accessDeniedPath) {
        this.invocationHelper = invocationHelper;
        this.accessGrantedPath = accessGrantedPath;
        this.accessDeniedPath = accessDeniedPath;
        GlobalConfiguration globalConfiguration = SecurityActions.getCacheManagerConfiguration(invocationHelper.getRestCacheManager().getInstance());
        PrincipalRoleMapper mapper = globalConfiguration.security().authorization().principalRoleMapper();
        this.principalRoleMapper = mapper instanceof MutablePrincipalRoleMapper ? (MutablePrincipalRoleMapper)mapper : null;
        RolePermissionMapper permissionMapper = globalConfiguration.security().authorization().rolePermissionMapper();
        this.rolePermissionMapper = permissionMapper instanceof MutableRolePermissionMapper ? (MutableRolePermissionMapper)permissionMapper : null;
    }

    @Override
    public Invocations getInvocations() {
        return new Invocations.Builder().invocation().methods(Method.GET).path("/v2/login").withAction("config").anonymous().handleWith(this::loginConfiguration).invocation().methods(Method.GET, Method.POST).deprecated().path("/v2/login").withAction("login").permission(AuthorizationPermission.NONE).name("USER LOGIN").auditContext(AuditContext.SERVER).handleWith(this::login).invocation().methods(Method.GET).deprecated().path("/v2/login").permission(AuthorizationPermission.NONE).name("USER LOGIN").auditContext(AuditContext.SERVER).handleWith(this::login).invocation().methods(Method.GET).path("/v2/security/user/acl").handleWith(this::acl).invocation().method(Method.GET).path("/v2/security/roles").permission(AuthorizationPermission.ADMIN).name("ROLES").auditContext(AuditContext.SERVER).handleWith(this::listAllRoles).invocation().method(Method.GET).path("/v2/security/roles/{principal}").permission(AuthorizationPermission.ADMIN).name("ROLES PRINCIPAL").auditContext(AuditContext.SERVER).handleWith(this::listPrincipalRoles).invocation().method(Method.PUT).path("/v2/security/roles/{principal}").withAction("grant").permission(AuthorizationPermission.ADMIN).name("ROLES GRANT").auditContext(AuditContext.SERVER).handleWith(this::grant).invocation().method(Method.PUT).path("/v2/security/roles/{principal}").withAction("deny").permission(AuthorizationPermission.ADMIN).name("ROLES DENY").auditContext(AuditContext.SERVER).handleWith(this::deny).invocation().methods(Method.POST, Method.PUT).path("/v2/security/permissions/{role}").permission(AuthorizationPermission.ADMIN).name("ROLES CREATE").auditContext(AuditContext.SERVER).handleWith(this::createRole).invocation().method(Method.DELETE).path("/v2/security/permissions/{role}").permission(AuthorizationPermission.ADMIN).name("ROLES DELETE").auditContext(AuditContext.SERVER).handleWith(this::deleteRole).invocation().method(Method.POST).path("/v2/security/cache").withAction("flush").permission(AuthorizationPermission.ADMIN).name("ACL CACHE FLUSH").auditContext(AuditContext.SERVER).handleWith(this::aclCacheFlush).create();
    }

    private CompletionStage<RestResponse> createRole(RestRequest request) {
        NettyRestResponse.Builder builder = this.invocationHelper.newResponse(request);
        if (this.rolePermissionMapper == null) {
            return CompletableFuture.completedFuture(this.invocationHelper.newResponse(request).status(HttpResponseStatus.CONFLICT).entity(Log.REST.rolePermissionMapperNotMutable()).build());
        }
        String name = request.variables().get("role");
        List<String> perms = request.parameters().get("permission");
        if (perms == null) {
            return CompletableFuture.completedFuture(builder.status(HttpResponseStatus.BAD_REQUEST).build());
        }
        Set permissions = perms.stream().map(p -> AuthorizationPermission.valueOf((String)p.toUpperCase())).collect(Collectors.toSet());
        CacheRoleImpl role = new CacheRoleImpl(name, true, permissions);
        return this.rolePermissionMapper.addRole((Role)role).thenCompose(ignore -> this.aclCacheFlush(request));
    }

    private CompletionStage<RestResponse> deleteRole(RestRequest request) {
        if (this.rolePermissionMapper == null) {
            return CompletableFuture.completedFuture(this.invocationHelper.newResponse(request).status(HttpResponseStatus.CONFLICT).entity(Log.REST.rolePermissionMapperNotMutable()).build());
        }
        String role = request.variables().get("role");
        return this.rolePermissionMapper.removeRole(role).thenCompose(ignore -> this.aclCacheFlush(request));
    }

    private CompletionStage<RestResponse> aclCacheFlush(RestRequest request) {
        EmbeddedCacheManager cm = this.invocationHelper.getRestCacheManager().getInstance();
        return ((GlobalSecurityManager)SecurityActions.getGlobalComponentRegistry(cm).getComponent(GlobalSecurityManager.class)).flushGlobalACLCache().thenApply(v -> this.invocationHelper.newResponse(request).status(HttpResponseStatus.NO_CONTENT).build());
    }

    private CompletionStage<RestResponse> deny(RestRequest request) {
        NettyRestResponse.Builder builder = this.invocationHelper.newResponse(request);
        if (this.principalRoleMapper == null) {
            return CompletableFuture.completedFuture(this.invocationHelper.newResponse(request).status(HttpResponseStatus.CONFLICT).entity(Log.REST.principalRoleMapperNotMutable()).build());
        }
        String principal = request.variables().get("principal");
        List<String> roles = request.parameters().get("role");
        if (roles == null) {
            return CompletableFuture.completedFuture(builder.status(HttpResponseStatus.BAD_REQUEST).build());
        }
        roles.forEach(r -> this.principalRoleMapper.deny(r, principal));
        return this.aclCacheFlush(request);
    }

    private CompletionStage<RestResponse> grant(RestRequest request) {
        NettyRestResponse.Builder builder = this.invocationHelper.newResponse(request);
        if (this.principalRoleMapper == null) {
            return CompletableFuture.completedFuture(this.invocationHelper.newResponse(request).status(HttpResponseStatus.CONFLICT).entity(Log.REST.principalRoleMapperNotMutable()).build());
        }
        String principal = request.variables().get("principal");
        List<String> roles = request.parameters().get("role");
        if (roles == null) {
            return CompletableFuture.completedFuture(builder.status(HttpResponseStatus.BAD_REQUEST).build());
        }
        roles.forEach(r -> this.principalRoleMapper.grant(r, principal));
        return this.aclCacheFlush(request);
    }

    private CompletionStage<RestResponse> listAllRoles(RestRequest request) {
        GlobalAuthorizationConfiguration authorization = this.invocationHelper.getRestCacheManager().getInstance().getCacheManagerConfiguration().security().authorization();
        if (!authorization.enabled()) {
            throw Log.REST.authorizationNotEnabled();
        }
        Json roles = Json.array();
        authorization.roles().entrySet().stream().filter(e -> ((Role)e.getValue()).isInheritable()).forEach(e -> roles.add(e.getKey()));
        return ResourceUtil.asJsonResponseFuture(this.invocationHelper.newResponse(request), roles, ResourceUtil.isPretty(request));
    }

    private CompletionStage<RestResponse> listPrincipalRoles(RestRequest request) {
        String principal = request.variables().get("principal");
        if (this.principalRoleMapper == null) {
            return CompletableFuture.completedFuture(this.invocationHelper.newResponse(request).status(HttpResponseStatus.CONFLICT).entity(Log.REST.principalRoleMapperNotMutable()).build());
        }
        Json roles = Json.array();
        this.principalRoleMapper.list(principal).forEach(r -> roles.add(r));
        return ResourceUtil.asJsonResponseFuture(this.invocationHelper.newResponse(request), roles, ResourceUtil.isPretty(request));
    }

    private CompletionStage<RestResponse> acl(RestRequest request) {
        Subject subject = request.getSubject();
        RestCacheManager<Object> rcm = this.invocationHelper.getRestCacheManager();
        Collection<String> cacheNames = rcm.getCacheNames();
        Json acl = Json.object();
        if (subject == null) {
            acl.set("subject", Json.array());
        } else {
            Json jsonSubjects = Json.array();
            subject.getPrincipals().forEach(principal -> jsonSubjects.add(Json.object().set("name", (Object)principal.getName()).set("type", (Object)principal.getClass().getSimpleName())));
            acl.set("subject", jsonSubjects);
            Authorizer authorizer = rcm.getAuthorizer();
            SubjectACL globalACL = authorizer.getACL(subject);
            acl.set("global", this.aclToJson(globalACL));
            Json caches = Json.object();
            acl.set("caches", caches);
            for (String cacheName : cacheNames) {
                Configuration cacheConfiguration = SecurityActions.getCacheConfigurationFromManager(rcm.getInstance(), cacheName);
                SubjectACL cacheACL = authorizer.getACL(subject, cacheConfiguration.security().authorization());
                caches.set(cacheName, this.aclToJson(cacheACL));
            }
        }
        return ResourceUtil.asJsonResponseFuture(this.invocationHelper.newResponse(request), acl, ResourceUtil.isPretty(request));
    }

    private Json aclToJson(SubjectACL acl) {
        Json array = Json.array();
        for (AuthorizationPermission permission : acl.getPermissions()) {
            array.add((Object)permission.name());
        }
        return array;
    }

    private CompletionStage<RestResponse> loginConfiguration(RestRequest request) {
        Map loginConfiguration = this.invocationHelper.getServer().getLoginConfiguration((ProtocolServer)this.invocationHelper.getProtocolServer());
        return ResourceUtil.asJsonResponseFuture(this.invocationHelper.newResponse(request), Json.make((Object)loginConfiguration), ResourceUtil.isPretty(request));
    }

    private CompletionStage<RestResponse> login(RestRequest request) {
        NettyRestResponse.Builder responseBuilder = this.invocationHelper.newResponse(request);
        responseBuilder.status(HttpResponseStatus.TEMPORARY_REDIRECT).header("Location", this.accessGrantedPath);
        return CompletableFuture.completedFuture(responseBuilder.build());
    }
}

