/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.resources;

import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Date;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.dataconversion.MediaTypeResolver;
import org.infinispan.rest.DateUtils;
import org.infinispan.rest.InvocationHelper;
import org.infinispan.rest.NettyRestResponse;
import org.infinispan.rest.framework.Method;
import org.infinispan.rest.framework.ResourceHandler;
import org.infinispan.rest.framework.RestRequest;
import org.infinispan.rest.framework.RestResponse;
import org.infinispan.rest.framework.impl.Invocations;

public class StaticContentResource
implements ResourceHandler {
    private final Path dir;
    private final String urlPath;
    private static final int CACHE_MAX_AGE_SECONDS = 2678400;
    public static final String DEFAULT_RESOURCE = "index.html";
    private final String noFileUri;
    private final ResourceResolver customResourceResolver;
    private final String rootUri;
    private final InvocationHelper invocationHelper;

    public StaticContentResource(InvocationHelper invocationHelper, Path dir, String urlPath, ResourceResolver resourceResolver) {
        this.invocationHelper = invocationHelper;
        this.dir = dir.toAbsolutePath();
        this.urlPath = urlPath;
        this.noFileUri = "/" + urlPath;
        this.customResourceResolver = resourceResolver;
        this.rootUri = this.noFileUri + "/";
    }

    public StaticContentResource(InvocationHelper invocationHelper, Path dir, String urlPath) {
        this(invocationHelper, dir, urlPath, null);
    }

    @Override
    public Invocations getInvocations() {
        return new Invocations.Builder().invocation().methods(Method.GET).anonymous(true).path(this.urlPath + "/").path(this.urlPath + "/*").handleWith(this::serveFile).create();
    }

    private File resolve(String resource) {
        Path resolved = this.dir.resolve(resource);
        try {
            if (!resolved.toFile().getCanonicalPath().startsWith(this.dir.toFile().getCanonicalPath())) {
                return null;
            }
        }
        catch (IOException e) {
            return null;
        }
        File file = resolved.toFile();
        if (!file.isFile() || !file.exists()) {
            return null;
        }
        return file;
    }

    private CompletionStage<RestResponse> serveFile(RestRequest restRequest) {
        boolean isNotModified;
        NettyRestResponse.Builder responseBuilder = this.invocationHelper.newResponse(restRequest);
        String uri = restRequest.uri();
        if (uri.equals(this.noFileUri)) {
            return CompletableFuture.completedFuture(responseBuilder.location(this.rootUri).status(HttpResponseStatus.MOVED_PERMANENTLY).build());
        }
        String resource = uri.substring(uri.indexOf(this.urlPath) + this.urlPath.length() + 1);
        if (this.customResourceResolver != null) {
            resource = this.customResourceResolver.rewrite(resource, this);
        } else if (uri.equals(this.rootUri)) {
            resource = DEFAULT_RESOURCE;
        }
        File file = this.resolve(resource);
        if (file == null) {
            return CompletableFuture.completedFuture(responseBuilder.status(HttpResponseStatus.NOT_FOUND).build());
        }
        String ifModifiedSince = restRequest.getIfModifiedSinceHeader();
        if (ifModifiedSince != null && !ifModifiedSince.isEmpty() && (isNotModified = DateUtils.isNotModifiedSince(ifModifiedSince, file.lastModified()))) {
            responseBuilder.status(HttpResponseStatus.NOT_MODIFIED);
            return CompletableFuture.completedFuture(responseBuilder.build());
        }
        responseBuilder.lastModified(file.lastModified());
        responseBuilder.header("Cache-control", "private, max-age=2678400");
        Date now = new Date();
        responseBuilder.addProcessedDate(now);
        responseBuilder.header("Expires", DateUtils.toRFC1123(now.getTime() + TimeUnit.SECONDS.toMillis(2678400L)));
        String resolved = MediaTypeResolver.getMediaType((String)file.getName());
        String mediaType = resolved != null ? resolved : "application/octet-stream";
        responseBuilder.contentLength(file.length()).contentType(mediaType).entity(file);
        return CompletableFuture.completedFuture(responseBuilder.build());
    }

    public static interface ResourceResolver {
        public String rewrite(String var1, StaticContentResource var2);
    }
}

