/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration;

import io.agroal.api.configuration.AgroalConnectionFactoryConfiguration;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.io.ConfigurationReader;
import org.infinispan.commons.configuration.io.ConfigurationReaderContext;
import org.infinispan.commons.util.InstanceSupplier;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.internal.PrivateGlobalConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ConfigurationParser;
import org.infinispan.configuration.parsing.Namespace;
import org.infinispan.configuration.parsing.Namespaces;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.configuration.parsing.ParserScope;
import org.infinispan.rest.configuration.RestServerConfigurationBuilder;
import org.infinispan.server.Server;
import org.infinispan.server.configuration.AddressType;
import org.infinispan.server.configuration.Attribute;
import org.infinispan.server.configuration.DataSourceConfigurationBuilder;
import org.infinispan.server.configuration.DataSourcesConfigurationBuilder;
import org.infinispan.server.configuration.Element;
import org.infinispan.server.configuration.InterfaceConfigurationBuilder;
import org.infinispan.server.configuration.ServerConfigurationBuilder;
import org.infinispan.server.configuration.SocketBindingsConfigurationBuilder;
import org.infinispan.server.configuration.endpoint.EndpointConfigurationBuilder;
import org.infinispan.server.configuration.security.CredentialStoreConfigurationBuilder;
import org.infinispan.server.configuration.security.CredentialStoresConfigurationBuilder;
import org.infinispan.server.configuration.security.DistributedRealmConfigurationBuilder;
import org.infinispan.server.configuration.security.FileSystemRealmConfigurationBuilder;
import org.infinispan.server.configuration.security.GroupsPropertiesConfigurationBuilder;
import org.infinispan.server.configuration.security.JwtConfigurationBuilder;
import org.infinispan.server.configuration.security.KerberosSecurityFactoryConfigurationBuilder;
import org.infinispan.server.configuration.security.KeyStoreConfigurationBuilder;
import org.infinispan.server.configuration.security.LdapAttributeConfigurationBuilder;
import org.infinispan.server.configuration.security.LdapIdentityMappingConfigurationBuilder;
import org.infinispan.server.configuration.security.LdapRealmConfigurationBuilder;
import org.infinispan.server.configuration.security.LdapUserPasswordMapperConfigurationBuilder;
import org.infinispan.server.configuration.security.LocalRealmConfigurationBuilder;
import org.infinispan.server.configuration.security.OAuth2ConfigurationBuilder;
import org.infinispan.server.configuration.security.PropertiesRealmConfigurationBuilder;
import org.infinispan.server.configuration.security.RealmConfigurationBuilder;
import org.infinispan.server.configuration.security.RealmsConfigurationBuilder;
import org.infinispan.server.configuration.security.SSLConfigurationBuilder;
import org.infinispan.server.configuration.security.SSLEngineConfigurationBuilder;
import org.infinispan.server.configuration.security.ServerIdentitiesConfigurationBuilder;
import org.infinispan.server.configuration.security.TokenRealmConfigurationBuilder;
import org.infinispan.server.configuration.security.TrustStoreConfigurationBuilder;
import org.infinispan.server.configuration.security.TrustStoreRealmConfigurationBuilder;
import org.infinispan.server.configuration.security.UserPropertiesConfigurationBuilder;
import org.infinispan.server.core.configuration.IpFilterConfigurationBuilder;
import org.infinispan.server.core.configuration.ProtocolServerConfigurationBuilder;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.wildfly.security.auth.realm.ldap.DirContextFactory;
import org.wildfly.security.auth.server.NameRewriter;
import org.wildfly.security.auth.util.RegexNameRewriter;

@Namespaces(value={@Namespace(root="server"), @Namespace(uri="urn:infinispan:server:*", root="server"), @Namespace(uri="urn:infinispan:server:*", root="transport")})
public class ServerConfigurationParser
implements ConfigurationParser {
    private static final Log coreLog = LogFactory.getLog(ServerConfigurationParser.class);
    static final String NAMESPACE = "urn:infinispan:server:";
    public static String ENDPOINTS_SCOPE = "ENDPOINTS";

    public Namespace[] getNamespaces() {
        return ParseUtils.getNamespaceAnnotations(this.getClass());
    }

    public static Element nextElement(ConfigurationReader reader) {
        if (reader.nextElement() == ConfigurationReader.ElementType.END_ELEMENT) {
            return null;
        }
        return Element.forName(reader.getLocalName());
    }

    public void readElement(ConfigurationReader reader, ConfigurationBuilderHolder holder) {
        if (!holder.inScope((Enum)ParserScope.GLOBAL)) {
            throw coreLog.invalidScope(ParserScope.GLOBAL.name(), holder.getScope());
        }
        GlobalConfigurationBuilder builder = holder.getGlobalConfigurationBuilder();
        Element element = Element.forName(reader.getLocalName());
        switch (element) {
            case SERVER: {
                ((PrivateGlobalConfigurationBuilder)builder.addModule(PrivateGlobalConfigurationBuilder.class)).serverMode(true);
                ServerConfigurationBuilder serverConfigurationBuilder = ((ServerConfigurationBuilder)builder.addModule(ServerConfigurationBuilder.class)).properties(reader.getProperties());
                this.parseServerElements(reader, holder, serverConfigurationBuilder);
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((ConfigurationReader)reader);
            }
        }
    }

    private void parseServerElements(ConfigurationReader reader, ConfigurationBuilderHolder holder, ServerConfigurationBuilder builder) {
        block7: while (reader.inTag()) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case INTERFACES: {
                    this.parseInterfaces(reader, builder);
                    continue block7;
                }
                case SOCKET_BINDINGS: {
                    this.parseSocketBindings(reader, builder);
                    continue block7;
                }
                case SECURITY: {
                    this.parseSecurity(reader, builder);
                    continue block7;
                }
                case DATA_SOURCES: {
                    this.parseDataSources(reader, builder);
                    continue block7;
                }
                case ENDPOINTS: {
                    holder.pushScope(ENDPOINTS_SCOPE);
                    if (reader.getSchema().since(13, 0)) {
                        this.parseEndpoints(reader, holder, builder);
                    } else {
                        while (reader.inTag()) {
                            this.parseEndpoint(reader, holder, builder, Element.ENDPOINTS, null, null);
                        }
                    }
                    holder.popScope();
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement((ConfigurationReader)reader, (Enum)element);
        }
    }

    private void parseSocketBindings(ConfigurationReader reader, ServerConfigurationBuilder builder) {
        SocketBindingsConfigurationBuilder socketBindings = builder.socketBindings();
        String[] attributes = ParseUtils.requireAttributes((ConfigurationReader)reader, (Enum[])new Enum[]{Attribute.DEFAULT_INTERFACE, Attribute.PORT_OFFSET});
        block4: while (reader.inTag((Enum)Element.SOCKET_BINDINGS)) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case BINDINGS: {
                    continue block4;
                }
                case SOCKET_BINDING: {
                    if (reader.getAttributeCount() <= 0) continue block4;
                    socketBindings.defaultInterface(attributes[0]).offset(Integer.parseInt(attributes[1]));
                    this.parseSocketBinding(reader, socketBindings);
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement((ConfigurationReader)reader);
        }
    }

    private void parseSocketBinding(ConfigurationReader reader, SocketBindingsConfigurationBuilder builder) {
        String[] attributes = ParseUtils.requireAttributes((ConfigurationReader)reader, (Enum[])new Enum[]{Attribute.NAME, Attribute.PORT});
        String name = attributes[0];
        int port = Integer.parseInt(attributes[1]);
        String interfaceName = builder.defaultInterface();
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((ConfigurationReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case NAME: 
                case PORT: {
                    continue block4;
                }
                case INTERFACE: {
                    interfaceName = value;
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((ConfigurationReader)reader, (int)i);
                }
            }
        }
        builder.socketBinding(name, port, interfaceName);
        ParseUtils.requireNoContent((ConfigurationReader)reader);
    }

    private void parseInterfaces(ConfigurationReader reader, ServerConfigurationBuilder builder) {
        block3: while (reader.inTag()) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case INTERFACES: 
                case INTERFACE: {
                    this.parseInterface(reader, builder);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((ConfigurationReader)reader);
        }
    }

    private void parseInterface(ConfigurationReader reader, ServerConfigurationBuilder builder) {
        String[] attributes = ParseUtils.requireAttributes((ConfigurationReader)reader, (Enum[])new Enum[]{Attribute.NAME});
        String name = attributes[0];
        InterfaceConfigurationBuilder iface = builder.interfaces().addInterface(name);
        boolean matched = false;
        CacheConfigurationException cce = Server.log.invalidNetworkConfiguration();
        while (reader.inTag()) {
            Element element = Element.forName(reader.getLocalName());
            try {
                switch (element) {
                    case INET_ADDRESS: {
                        String value = ParseUtils.requireSingleAttribute((ConfigurationReader)reader, (Enum)Attribute.VALUE);
                        ParseUtils.requireNoContent((ConfigurationReader)reader);
                        if (matched) break;
                        iface.address(AddressType.INET_ADDRESS, value);
                        break;
                    }
                    case LINK_LOCAL: {
                        ParseUtils.requireNoAttributes((ConfigurationReader)reader);
                        ParseUtils.requireNoContent((ConfigurationReader)reader);
                        if (matched) break;
                        iface.address(AddressType.LINK_LOCAL, null);
                        break;
                    }
                    case GLOBAL: {
                        ParseUtils.requireNoAttributes((ConfigurationReader)reader);
                        ParseUtils.requireNoContent((ConfigurationReader)reader);
                        if (matched) break;
                        iface.address(AddressType.GLOBAL, null);
                        break;
                    }
                    case LOOPBACK: {
                        ParseUtils.requireNoAttributes((ConfigurationReader)reader);
                        ParseUtils.requireNoContent((ConfigurationReader)reader);
                        if (matched) break;
                        iface.address(AddressType.LOOPBACK, null);
                        break;
                    }
                    case NON_LOOPBACK: {
                        ParseUtils.requireNoAttributes((ConfigurationReader)reader);
                        ParseUtils.requireNoContent((ConfigurationReader)reader);
                        if (matched) break;
                        iface.address(AddressType.NON_LOOPBACK, null);
                        break;
                    }
                    case SITE_LOCAL: {
                        ParseUtils.requireNoAttributes((ConfigurationReader)reader);
                        ParseUtils.requireNoContent((ConfigurationReader)reader);
                        if (matched) break;
                        iface.address(AddressType.SITE_LOCAL, null);
                        break;
                    }
                    case MATCH_INTERFACE: {
                        String value = ParseUtils.requireSingleAttribute((ConfigurationReader)reader, (Enum)Attribute.VALUE);
                        ParseUtils.requireNoContent((ConfigurationReader)reader);
                        if (matched) break;
                        iface.address(AddressType.MATCH_INTERFACE, value);
                        break;
                    }
                    case MATCH_ADDRESS: {
                        String value = ParseUtils.requireSingleAttribute((ConfigurationReader)reader, (Enum)Attribute.VALUE);
                        ParseUtils.requireNoContent((ConfigurationReader)reader);
                        if (matched) break;
                        iface.address(AddressType.MATCH_ADDRESS, value);
                        break;
                    }
                    case MATCH_HOST: {
                        String value = ParseUtils.requireSingleAttribute((ConfigurationReader)reader, (Enum)Attribute.VALUE);
                        ParseUtils.requireNoContent((ConfigurationReader)reader);
                        if (matched) break;
                        iface.address(AddressType.MATCH_HOST, value);
                        break;
                    }
                    case ANY_ADDRESS: {
                        ParseUtils.requireNoAttributes((ConfigurationReader)reader);
                        ParseUtils.requireNoContent((ConfigurationReader)reader);
                        if (matched) break;
                        iface.address(AddressType.ANY_ADDRESS, null);
                        break;
                    }
                    default: {
                        throw ParseUtils.unexpectedElement((ConfigurationReader)reader);
                    }
                }
                matched = true;
            }
            catch (IOException e) {
                cce.addSuppressed((Throwable)e);
            }
        }
        if (!matched) {
            throw cce;
        }
    }

    private void parseSecurity(ConfigurationReader reader, ServerConfigurationBuilder builder) {
        block4: while (reader.inTag()) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case CREDENTIAL_STORES: {
                    this.parseCredentialStores(reader, builder);
                    continue block4;
                }
                case SECURITY_REALMS: {
                    this.parseSecurityRealms(reader, builder);
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement((ConfigurationReader)reader, (Enum)element);
        }
    }

    private void parseCredentialStores(ConfigurationReader reader, ServerConfigurationBuilder builder) {
        CredentialStoresConfigurationBuilder credentialStores = builder.security().credentialStores();
        block3: while (reader.inTag()) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case CREDENTIAL_STORES: 
                case CREDENTIAL_STORE: {
                    this.parseCredentialStore(reader, builder, credentialStores);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((ConfigurationReader)reader);
        }
    }

    private void parseCredentialStore(ConfigurationReader reader, ServerConfigurationBuilder builder, CredentialStoresConfigurationBuilder credentialStores) {
        String name = ParseUtils.requireAttributes((ConfigurationReader)reader, (Enum[])new Enum[]{Attribute.NAME, Attribute.PATH})[0];
        CredentialStoreConfigurationBuilder credentialStoreBuilder = credentialStores.addCredentialStore(name);
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((ConfigurationReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case NAME: {
                    continue block6;
                }
                case PATH: {
                    credentialStoreBuilder.path(value);
                    continue block6;
                }
                case RELATIVE_TO: {
                    credentialStoreBuilder.relativeTo(value);
                    continue block6;
                }
                case TYPE: {
                    credentialStoreBuilder.type(value);
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((ConfigurationReader)reader, (int)i);
                }
            }
        }
        Element element = ServerConfigurationParser.nextElement(reader);
        if (element == Element.CREDENTIAL_REFERENCE || element == Element.CLEAR_TEXT_CREDENTIAL) {
            credentialStoreBuilder.credential(this.parseCredentialReference(reader, builder));
            element = ServerConfigurationParser.nextElement(reader);
        }
        if (element != null) {
            throw ParseUtils.unexpectedElement((ConfigurationReader)reader, (Enum)element);
        }
    }

    private Supplier<char[]> parseCredentialReference(ConfigurationReader reader, ServerConfigurationBuilder builder) {
        switch (Element.forName(reader.getLocalName())) {
            case CREDENTIAL_REFERENCE: {
                String store = null;
                String alias = null;
                block8: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                    ParseUtils.requireNoNamespaceAttribute((ConfigurationReader)reader, (int)i);
                    String value = reader.getAttributeValue(i);
                    Attribute attribute = Attribute.forName(reader.getAttributeName(i));
                    switch (attribute) {
                        case STORE: {
                            store = value;
                            continue block8;
                        }
                        case ALIAS: {
                            alias = value;
                            continue block8;
                        }
                        default: {
                            throw ParseUtils.unexpectedAttribute((ConfigurationReader)reader, (int)i);
                        }
                    }
                }
                ParseUtils.requireNoContent((ConfigurationReader)reader);
                return builder.security().credentialStores().getCredential(store, alias);
            }
            case CLEAR_TEXT_CREDENTIAL: {
                String credential = ParseUtils.requireSingleAttribute((ConfigurationReader)reader, (Enum)Attribute.CLEAR_TEXT);
                ParseUtils.requireNoContent((ConfigurationReader)reader);
                return new InstanceSupplier((Object)credential.toCharArray());
            }
        }
        throw ParseUtils.unexpectedElement((ConfigurationReader)reader);
    }

    private void parseSecurityRealms(ConfigurationReader reader, ServerConfigurationBuilder builder) {
        RealmsConfigurationBuilder realms = builder.security().realms();
        block3: while (reader.inTag()) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case SECURITY_REALMS: 
                case SECURITY_REALM: {
                    this.parseSecurityRealm(reader, builder, realms);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((ConfigurationReader)reader);
        }
    }

    private void parseSecurityRealm(ConfigurationReader reader, ServerConfigurationBuilder builder, RealmsConfigurationBuilder realms) {
        String name = ParseUtils.requireAttributes((ConfigurationReader)reader, (Enum[])new Enum[]{Attribute.NAME})[0];
        RealmConfigurationBuilder securityRealmBuilder = realms.addSecurityRealm(name);
        block16: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((ConfigurationReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case NAME: {
                    continue block16;
                }
                case DEFAULT_REALM: {
                    securityRealmBuilder.defaultRealm(value);
                    continue block16;
                }
                case CACHE_LIFESPAN: {
                    securityRealmBuilder.cacheLifespan(Long.valueOf(value));
                    continue block16;
                }
                case CACHE_MAX_SIZE: {
                    securityRealmBuilder.cacheMaxSize(Integer.valueOf(value));
                    continue block16;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((ConfigurationReader)reader, (int)i);
                }
            }
        }
        block17: while (reader.inTag()) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case SERVER_IDENTITIES: {
                    this.parseServerIdentities(reader, builder, securityRealmBuilder);
                    continue block17;
                }
                case DISTRIBUTED_REALM: {
                    this.parseDistributedRealm(reader, securityRealmBuilder.distributedConfiguration());
                    continue block17;
                }
                case FILESYSTEM_REALM: {
                    this.parseFileSystemRealm(reader, securityRealmBuilder.fileSystemConfiguration());
                    continue block17;
                }
                case LDAP_REALM: {
                    this.parseLdapRealm(reader, builder, securityRealmBuilder.ldapConfiguration());
                    continue block17;
                }
                case LOCAL_REALM: {
                    this.parseLocalRealm(reader, securityRealmBuilder.localConfiguration());
                    continue block17;
                }
                case PROPERTIES_REALM: {
                    this.parsePropertiesRealm(reader, securityRealmBuilder.propertiesConfiguration(), name);
                    continue block17;
                }
                case TOKEN_REALM: {
                    this.parseTokenRealm(reader, builder, securityRealmBuilder.tokenConfiguration());
                    continue block17;
                }
                case TRUSTSTORE_REALM: {
                    if (reader.getSchema().since(12, 1)) {
                        this.parseTrustStoreRealm(reader, securityRealmBuilder.trustStoreConfiguration());
                        continue block17;
                    }
                    this.parseLegacyTrustStoreRealm(reader, builder, securityRealmBuilder.trustStoreConfiguration(), securityRealmBuilder.serverIdentitiesConfiguration());
                    continue block17;
                }
            }
            throw ParseUtils.unexpectedElement((ConfigurationReader)reader, (Enum)element);
        }
    }

    private void parseFileSystemRealm(ConfigurationReader reader, FileSystemRealmConfigurationBuilder fileRealmBuilder) {
        String path = ParseUtils.requireAttributes((ConfigurationReader)reader, (Enum[])new Enum[]{Attribute.PATH})[0];
        fileRealmBuilder.path(path);
        String relativeTo = "infinispan.server.data.path";
        boolean encoded = true;
        int levels = 0;
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((ConfigurationReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case NAME: {
                    fileRealmBuilder.name(value);
                    continue block7;
                }
                case ENCODED: {
                    encoded = Boolean.parseBoolean(value);
                    fileRealmBuilder.encoded(encoded);
                    continue block7;
                }
                case LEVELS: {
                    levels = Integer.parseInt(value);
                    fileRealmBuilder.levels(levels);
                    continue block7;
                }
                case PATH: {
                    continue block7;
                }
                case RELATIVE_TO: {
                    relativeTo = ParseUtils.requireAttributeProperty((ConfigurationReader)reader, (int)i);
                    fileRealmBuilder.relativeTo(relativeTo);
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((ConfigurationReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((ConfigurationReader)reader);
        fileRealmBuilder.path(path).relativeTo(relativeTo).levels(levels).encoded(encoded);
    }

    private void parseTokenRealm(ConfigurationReader reader, ServerConfigurationBuilder serverBuilder, TokenRealmConfigurationBuilder tokenRealmConfigBuilder) {
        String[] required = ParseUtils.requireAttributes((ConfigurationReader)reader, (Enum[])new Enum[]{Attribute.NAME, Attribute.AUTH_SERVER_URL, Attribute.CLIENT_ID});
        tokenRealmConfigBuilder.name(required[0]).authServerUrl(required[1]).clientId(required[2]);
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((ConfigurationReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case NAME: 
                case AUTH_SERVER_URL: 
                case CLIENT_ID: {
                    continue block4;
                }
                case PRINCIPAL_CLAIM: {
                    tokenRealmConfigBuilder.principalClaim(value);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((ConfigurationReader)reader, (int)i);
                }
            }
        }
        Element element = ServerConfigurationParser.nextElement(reader);
        if (element == Element.JWT) {
            this.parseJWT(reader, serverBuilder, tokenRealmConfigBuilder.jwtConfiguration());
            element = ServerConfigurationParser.nextElement(reader);
        } else if (element == Element.OAUTH2_INTROSPECTION) {
            this.parseOauth2Introspection(reader, serverBuilder, tokenRealmConfigBuilder.oauth2Configuration());
            element = ServerConfigurationParser.nextElement(reader);
        }
        if (element != null) {
            throw ParseUtils.unexpectedElement((ConfigurationReader)reader);
        }
    }

    private void parseJWT(ConfigurationReader reader, ServerConfigurationBuilder serverBuilder, JwtConfigurationBuilder jwtBuilder) {
        block10: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((ConfigurationReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case ISSUER: {
                    jwtBuilder.issuers(reader.getListAttributeValue(i));
                    continue block10;
                }
                case AUDIENCE: {
                    jwtBuilder.audience(reader.getListAttributeValue(i));
                    continue block10;
                }
                case PUBLIC_KEY: {
                    jwtBuilder.publicKey(value);
                    continue block10;
                }
                case JKU_TIMEOUT: {
                    jwtBuilder.jkuTimeout(Long.parseLong(value));
                    continue block10;
                }
                case CLIENT_SSL_CONTEXT: {
                    jwtBuilder.clientSSLContext(value);
                    continue block10;
                }
                case HOST_NAME_VERIFICATION_POLICY: {
                    jwtBuilder.hostNameVerificationPolicy(value);
                    continue block10;
                }
                case CONNECTION_TIMEOUT: {
                    jwtBuilder.connectionTimeout(Integer.parseInt(value));
                    continue block10;
                }
                case READ_TIMEOUT: {
                    jwtBuilder.readTimeout(Integer.parseInt(value));
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((ConfigurationReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((ConfigurationReader)reader);
    }

    private void parseOauth2Introspection(ConfigurationReader reader, ServerConfigurationBuilder serverBuilder, OAuth2ConfigurationBuilder oauthBuilder) {
        String[] required = ParseUtils.requireAttributes((ConfigurationReader)reader, (Enum[])new Enum[]{Attribute.CLIENT_ID, Attribute.INTROSPECTION_URL});
        oauthBuilder.clientId(required[0]).introspectionUrl(required[1]);
        boolean credentialSet = false;
        block8: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((ConfigurationReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case CLIENT_ID: 
                case INTROSPECTION_URL: {
                    continue block8;
                }
                case CLIENT_SECRET: {
                    oauthBuilder.clientSecret(value.toCharArray());
                    credentialSet = true;
                    continue block8;
                }
                case CLIENT_SSL_CONTEXT: {
                    oauthBuilder.clientSSLContext(value);
                    continue block8;
                }
                case HOST_NAME_VERIFICATION_POLICY: {
                    oauthBuilder.hostVerificationPolicy(value);
                    continue block8;
                }
                case CONNECTION_TIMEOUT: {
                    oauthBuilder.connectionTimeout(Integer.parseInt(value));
                    continue block8;
                }
                case READ_TIMEOUT: {
                    oauthBuilder.readTimeout(Integer.parseInt(value));
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((ConfigurationReader)reader, (int)i);
                }
            }
        }
        Element element = ServerConfigurationParser.nextElement(reader);
        if (element == Element.CREDENTIAL_REFERENCE) {
            if (credentialSet) {
                throw Server.log.cannotOverrideCredential(Element.OAUTH2_INTROSPECTION.toString(), Attribute.CLIENT_SECRET.toString());
            }
            oauthBuilder.clientSecret(this.parseCredentialReference(reader, serverBuilder));
            credentialSet = true;
            element = ServerConfigurationParser.nextElement(reader);
        }
        if (!credentialSet) {
            throw Server.log.missingCredential(Element.OAUTH2_INTROSPECTION.toString(), Attribute.CLIENT_SECRET.toString());
        }
        if (element != null) {
            throw ParseUtils.unexpectedElement((ConfigurationReader)reader, (Enum)element);
        }
    }

    private void parseLdapRealm(ConfigurationReader reader, ServerConfigurationBuilder builder, LdapRealmConfigurationBuilder ldapRealmConfigBuilder) {
        boolean credentialSet = false;
        block19: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((ConfigurationReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case NAME: {
                    ldapRealmConfigBuilder.name(value);
                    continue block19;
                }
                case URL: {
                    ldapRealmConfigBuilder.url(value);
                    continue block19;
                }
                case PRINCIPAL: {
                    ldapRealmConfigBuilder.principal(value);
                    continue block19;
                }
                case CREDENTIAL: {
                    ldapRealmConfigBuilder.credential(value.toCharArray());
                    credentialSet = true;
                    continue block19;
                }
                case DIRECT_VERIFICATION: {
                    ldapRealmConfigBuilder.directEvidenceVerification(Boolean.parseBoolean(value));
                    continue block19;
                }
                case PAGE_SIZE: {
                    ldapRealmConfigBuilder.pageSize(Integer.parseInt(value));
                    continue block19;
                }
                case SEARCH_DN: {
                    if (reader.getSchema().since(13, 0)) {
                        throw ParseUtils.unexpectedAttribute((ConfigurationReader)reader, (int)i);
                    }
                    ldapRealmConfigBuilder.identityMapping().searchBaseDn(value);
                    continue block19;
                }
                case RDN_IDENTIFIER: {
                    if (reader.getSchema().since(13, 0)) {
                        throw ParseUtils.unexpectedAttribute((ConfigurationReader)reader, (int)i);
                    }
                    ldapRealmConfigBuilder.identityMapping().rdnIdentifier(value);
                    continue block19;
                }
                case CONNECTION_POOLING: {
                    ldapRealmConfigBuilder.connectionPooling(Boolean.parseBoolean(value));
                    continue block19;
                }
                case CONNECTION_TIMEOUT: {
                    ldapRealmConfigBuilder.connectionTimeout(Integer.parseInt(value));
                    continue block19;
                }
                case READ_TIMEOUT: {
                    ldapRealmConfigBuilder.readTimeout(Integer.parseInt(value));
                    continue block19;
                }
                case REFERRAL_MODE: {
                    ldapRealmConfigBuilder.referralMode(DirContextFactory.ReferralMode.valueOf((String)value.toUpperCase()));
                    continue block19;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((ConfigurationReader)reader, (int)i);
                }
            }
        }
        block20: while (reader.inTag()) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case CREDENTIAL_REFERENCE: {
                    if (credentialSet) {
                        throw Server.log.cannotOverrideCredential(Element.LDAP_REALM.toString(), Attribute.CREDENTIAL.toString());
                    }
                    ldapRealmConfigBuilder.credential(this.parseCredentialReference(reader, builder));
                    credentialSet = true;
                    continue block20;
                }
                case NAME_REWRITER: {
                    this.parseNameRewriter(reader, ldapRealmConfigBuilder);
                    continue block20;
                }
                case IDENTITY_MAPPING: {
                    this.parseLdapIdentityMapping(reader, ldapRealmConfigBuilder.identityMapping());
                    continue block20;
                }
            }
            throw ParseUtils.unexpectedElement((ConfigurationReader)reader, (Enum)element);
        }
        if (!credentialSet) {
            throw Server.log.missingCredential(Element.LDAP_REALM.toString(), Attribute.CREDENTIAL.toString());
        }
    }

    private void parseNameRewriter(ConfigurationReader reader, LdapRealmConfigurationBuilder builder) {
        Element element = ServerConfigurationParser.nextElement(reader);
        switch (element) {
            case REGEX_PRINCIPAL_TRANSFORMER: {
                String[] attributes = ParseUtils.requireAttributes((ConfigurationReader)reader, (Enum[])new Enum[]{Attribute.PATTERN, Attribute.REPLACEMENT});
                boolean replaceAll = false;
                block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                    ParseUtils.requireNoNamespaceAttribute((ConfigurationReader)reader, (int)i);
                    String value = reader.getAttributeValue(i);
                    Attribute attribute = Attribute.forName(reader.getAttributeName(i));
                    switch (attribute) {
                        case NAME: 
                        case PATTERN: 
                        case REPLACEMENT: {
                            continue block7;
                        }
                        case REPLACE_ALL: {
                            replaceAll = Boolean.parseBoolean(value);
                            continue block7;
                        }
                        default: {
                            throw ParseUtils.unexpectedAttribute((ConfigurationReader)reader, (int)i);
                        }
                    }
                }
                builder.nameRewriter((NameRewriter)new RegexNameRewriter(Pattern.compile(attributes[0]), attributes[1], replaceAll));
                ParseUtils.requireNoContent((ConfigurationReader)reader);
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((ConfigurationReader)reader);
            }
        }
        ParseUtils.requireNoContent((ConfigurationReader)reader);
    }

    private void parseLdapIdentityMapping(ConfigurationReader reader, LdapIdentityMappingConfigurationBuilder identityMapBuilder) {
        block11: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((ConfigurationReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case SEARCH_DN: {
                    identityMapBuilder.searchBaseDn(value);
                    continue block11;
                }
                case RDN_IDENTIFIER: {
                    identityMapBuilder.rdnIdentifier(value);
                    continue block11;
                }
                case SEARCH_RECURSIVE: {
                    identityMapBuilder.searchRecursive(Boolean.valueOf(value));
                    continue block11;
                }
                case SEARCH_TIME_LIMIT: {
                    identityMapBuilder.searchTimeLimit(Integer.parseInt(value));
                    continue block11;
                }
                case FILTER_NAME: {
                    identityMapBuilder.filterName(value);
                    continue block11;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((ConfigurationReader)reader, (int)i);
                }
            }
        }
        block12: while (reader.inTag()) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ATTRIBUTE_MAPPING: {
                    this.parseLdapAttributeMapping(reader, identityMapBuilder);
                    continue block12;
                }
                case USER_PASSWORD_MAPPER: {
                    this.parseLdapUserPasswordMapper(reader, identityMapBuilder.userPasswordMapper());
                    continue block12;
                }
            }
            throw ParseUtils.unexpectedElement((ConfigurationReader)reader, (Enum)element);
        }
    }

    private void parseLdapUserPasswordMapper(ConfigurationReader reader, LdapUserPasswordMapperConfigurationBuilder userMapperBuilder) {
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((ConfigurationReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case FROM: {
                    userMapperBuilder.from(value);
                    continue block5;
                }
                case WRITABLE: {
                    if (reader.getSchema().since(13, 0)) {
                        throw ParseUtils.unexpectedAttribute((ConfigurationReader)reader, (int)i);
                    }
                    ParseUtils.ignoreAttribute((ConfigurationReader)reader, (int)i);
                    continue block5;
                }
                case VERIFIABLE: {
                    userMapperBuilder.verifiable(Boolean.parseBoolean(value));
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((ConfigurationReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((ConfigurationReader)reader);
    }

    private void parseLdapAttributeMapping(ConfigurationReader reader, LdapIdentityMappingConfigurationBuilder identityMappingConfigurationBuilder) {
        ParseUtils.requireNoAttributes((ConfigurationReader)reader);
        block9: while (reader.inTag()) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ATTRIBUTE: {
                    this.parseLdapAttributeFilter(reader, identityMappingConfigurationBuilder.addAttributeMapping());
                    break;
                }
                case ATTRIBUTE_REFERENCE: {
                    this.parseLdapAttributeReference(reader, identityMappingConfigurationBuilder.addAttributeMapping());
                    break;
                }
                case ATTRIBUTE_MAPPING: {
                    block10: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                        Attribute attribute = Attribute.forName(reader.getAttributeName(i));
                        switch (attribute) {
                            case FILTER: {
                                this.parseLdapAttributeFilter(reader, identityMappingConfigurationBuilder.addAttributeMapping());
                                continue block10;
                            }
                            case REFERENCE: {
                                this.parseLdapAttributeReference(reader, identityMappingConfigurationBuilder.addAttributeMapping());
                            }
                        }
                    }
                    continue block9;
                }
                default: {
                    throw ParseUtils.unexpectedElement((ConfigurationReader)reader);
                }
            }
        }
    }

    private void parseLdapAttributeFilter(ConfigurationReader reader, LdapAttributeConfigurationBuilder attributeBuilder) {
        String filter = ParseUtils.requireAttributes((ConfigurationReader)reader, (Enum[])new Enum[]{Attribute.FILTER})[0];
        this.parseLdapAttribute(reader, attributeBuilder.filter(filter));
    }

    private void parseLdapAttributeReference(ConfigurationReader reader, LdapAttributeConfigurationBuilder attributeBuilder) {
        String reference = ParseUtils.requireAttributes((ConfigurationReader)reader, (Enum[])new Enum[]{Attribute.REFERENCE})[0];
        this.parseLdapAttribute(reader, attributeBuilder.reference(reference));
    }

    private void parseLdapAttribute(ConfigurationReader reader, LdapAttributeConfigurationBuilder attributeBuilder) {
        block10: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((ConfigurationReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case FILTER: 
                case REFERENCE: {
                    continue block10;
                }
                case FROM: {
                    attributeBuilder.from(value);
                    continue block10;
                }
                case TO: {
                    attributeBuilder.to(value);
                    continue block10;
                }
                case FILTER_DN: {
                    attributeBuilder.filterBaseDn(value);
                    continue block10;
                }
                case SEARCH_RECURSIVE: {
                    attributeBuilder.searchRecursive(Boolean.parseBoolean(value));
                    continue block10;
                }
                case ROLE_RECURSION: {
                    attributeBuilder.roleRecursion(Integer.parseInt(value));
                    continue block10;
                }
                case ROLE_RECURSION_NAME: {
                    attributeBuilder.roleRecursionName(value);
                    continue block10;
                }
                case EXTRACT_RDN: {
                    attributeBuilder.extractRdn(value);
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((ConfigurationReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((ConfigurationReader)reader);
    }

    private void parseLocalRealm(ConfigurationReader reader, LocalRealmConfigurationBuilder localBuilder) {
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((ConfigurationReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case NAME: {
                    localBuilder.name(value);
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((ConfigurationReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((ConfigurationReader)reader);
    }

    private void parsePropertiesRealm(ConfigurationReader reader, PropertiesRealmConfigurationBuilder propertiesBuilder, String realmName) {
        UserPropertiesConfigurationBuilder userPropertiesBuilder = propertiesBuilder.userProperties().digestRealmName(realmName);
        GroupsPropertiesConfigurationBuilder groupsBuilder = propertiesBuilder.groupProperties();
        block18: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((ConfigurationReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case NAME: {
                    propertiesBuilder.name(value);
                    userPropertiesBuilder.digestRealmName(value);
                    continue block18;
                }
                case GROUPS_ATTRIBUTE: {
                    propertiesBuilder.groupAttribute(value);
                    continue block18;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((ConfigurationReader)reader, (int)i);
                }
            }
        }
        block19: while (reader.inTag()) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case USER_PROPERTIES: {
                    int i;
                    String path = ParseUtils.requireAttributes((ConfigurationReader)reader, (Enum[])new Enum[]{Attribute.PATH})[0];
                    String relativeTo = "infinispan.server.config.path";
                    block20: for (i = 0; i < reader.getAttributeCount(); ++i) {
                        ParseUtils.requireNoNamespaceAttribute((ConfigurationReader)reader, (int)i);
                        String value = reader.getAttributeValue(i);
                        Attribute attribute = Attribute.forName(reader.getAttributeName(i));
                        switch (attribute) {
                            case PATH: {
                                continue block20;
                            }
                            case RELATIVE_TO: {
                                relativeTo = value;
                                continue block20;
                            }
                            case DIGEST_REALM_NAME: {
                                userPropertiesBuilder.digestRealmName(value);
                                continue block20;
                            }
                            case PLAIN_TEXT: {
                                userPropertiesBuilder.plainText(Boolean.parseBoolean(value));
                                continue block20;
                            }
                            default: {
                                throw ParseUtils.unexpectedAttribute((ConfigurationReader)reader, (int)i);
                            }
                        }
                    }
                    userPropertiesBuilder.path(path).relativeTo(relativeTo);
                    ParseUtils.requireNoContent((ConfigurationReader)reader);
                    continue block19;
                }
                case GROUP_PROPERTIES: {
                    int i;
                    String path = ParseUtils.requireAttributes((ConfigurationReader)reader, (Enum[])new Enum[]{Attribute.PATH})[0];
                    String relativeTo = "infinispan.server.config.path";
                    block21: for (i = 0; i < reader.getAttributeCount(); ++i) {
                        ParseUtils.requireNoNamespaceAttribute((ConfigurationReader)reader, (int)i);
                        Attribute attribute = Attribute.forName(reader.getAttributeName(i));
                        switch (attribute) {
                            case PATH: {
                                continue block21;
                            }
                            case RELATIVE_TO: {
                                relativeTo = reader.getAttributeValue(i);
                                continue block21;
                            }
                            default: {
                                throw ParseUtils.unexpectedAttribute((ConfigurationReader)reader, (int)i);
                            }
                        }
                    }
                    groupsBuilder.path(path).relativeTo(relativeTo);
                    ParseUtils.requireNoContent((ConfigurationReader)reader);
                    continue block19;
                }
            }
            throw ParseUtils.unexpectedElement((ConfigurationReader)reader, (Enum)element);
        }
    }

    private void parseDistributedRealm(ConfigurationReader reader, DistributedRealmConfigurationBuilder builder) {
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((ConfigurationReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case NAME: {
                    builder.name(value);
                    continue block4;
                }
                case REALMS: {
                    ParseUtils.requireAttributes((ConfigurationReader)reader, (Enum[])new Enum[]{Attribute.REALMS})[0].split("\\s+");
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((ConfigurationReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((ConfigurationReader)reader);
    }

    private void parseServerIdentities(ConfigurationReader reader, ServerConfigurationBuilder builder, RealmConfigurationBuilder securityRealmBuilder) {
        ServerIdentitiesConfigurationBuilder identitiesBuilder = securityRealmBuilder.serverIdentitiesConfiguration();
        block4: while (reader.inTag()) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case SSL: {
                    this.parseSSL(reader, builder, identitiesBuilder);
                    continue block4;
                }
                case KERBEROS: {
                    this.parseKerberos(reader, identitiesBuilder);
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement((ConfigurationReader)reader, (Enum)element);
        }
    }

    private void parseSSL(ConfigurationReader reader, ServerConfigurationBuilder builder, ServerIdentitiesConfigurationBuilder identitiesBuilder) {
        SSLConfigurationBuilder serverIdentitiesBuilder = identitiesBuilder.sslConfiguration();
        block5: while (reader.inTag()) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case KEYSTORE: {
                    this.parseKeyStore(reader, builder, serverIdentitiesBuilder.keyStore());
                    continue block5;
                }
                case TRUSTSTORE: {
                    this.parseTrustStore(reader, builder, serverIdentitiesBuilder.trustStore());
                    continue block5;
                }
                case ENGINE: {
                    this.parseSSLEngine(reader, serverIdentitiesBuilder.engine());
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement((ConfigurationReader)reader, (Enum)element);
        }
    }

    private void parseSSLEngine(ConfigurationReader reader, SSLEngineConfigurationBuilder engine) {
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((ConfigurationReader)reader, (int)i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case ENABLED_PROTOCOLS: {
                    engine.enabledProtocols(reader.getListAttributeValue(i));
                    continue block5;
                }
                case ENABLED_CIPHERSUITES: {
                    engine.enabledCiphersuitesFilter(reader.getAttributeValue(i));
                    continue block5;
                }
                case ENABLED_CIPHERSUITES_TLS13: {
                    engine.enabledCiphersuitesNames(reader.getAttributeValue(i));
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((ConfigurationReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((ConfigurationReader)reader);
    }

    private void parseKeyStore(ConfigurationReader reader, ServerConfigurationBuilder builder, KeyStoreConfigurationBuilder keyStoreBuilder) {
        boolean credentialSet = false;
        boolean pathSet = false;
        block11: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((ConfigurationReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case PATH: {
                    keyStoreBuilder.path(value);
                    pathSet = true;
                    continue block11;
                }
                case PROVIDER: {
                    keyStoreBuilder.provider(value);
                    continue block11;
                }
                case TYPE: {
                    keyStoreBuilder.type(value);
                    continue block11;
                }
                case RELATIVE_TO: {
                    keyStoreBuilder.relativeTo(value);
                    continue block11;
                }
                case KEYSTORE_PASSWORD: {
                    Log.CONFIG.attributeDeprecatedUseOther((Enum)Attribute.KEYSTORE_PASSWORD, (Enum)Element.KEYSTORE, (Enum)Attribute.PASSWORD);
                }
                case PASSWORD: {
                    keyStoreBuilder.keyStorePassword(value.toCharArray());
                    credentialSet = true;
                    continue block11;
                }
                case ALIAS: {
                    keyStoreBuilder.alias(value);
                    continue block11;
                }
                case KEY_PASSWORD: {
                    keyStoreBuilder.keyPassword(value.toCharArray());
                    continue block11;
                }
                case GENERATE_SELF_SIGNED_CERTIFICATE_HOST: {
                    keyStoreBuilder.generateSelfSignedCertificateHost(value);
                    continue block11;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((ConfigurationReader)reader, (int)i);
                }
            }
        }
        Element element = ServerConfigurationParser.nextElement(reader);
        if (element == Element.CREDENTIAL_REFERENCE) {
            if (credentialSet) {
                throw Server.log.cannotOverrideCredential(Element.KEYSTORE.toString(), Attribute.KEYSTORE_PASSWORD.toString());
            }
            keyStoreBuilder.keyStorePassword(this.parseCredentialReference(reader, builder));
            credentialSet = true;
            element = ServerConfigurationParser.nextElement(reader);
        }
        if (!credentialSet && pathSet) {
            throw Server.log.missingCredential(Element.KEYSTORE.toString(), Attribute.KEYSTORE_PASSWORD.toString());
        }
        if (element != null) {
            throw ParseUtils.unexpectedElement((ConfigurationReader)reader, (Enum)element);
        }
    }

    private void parseTrustStore(ConfigurationReader reader, ServerConfigurationBuilder builder, TrustStoreConfigurationBuilder trustStoreBuilder) {
        boolean credentialSet = false;
        boolean pathSet = false;
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((ConfigurationReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case PATH: {
                    trustStoreBuilder.path(value);
                    pathSet = true;
                    continue block7;
                }
                case PROVIDER: {
                    trustStoreBuilder.provider(value);
                    continue block7;
                }
                case TYPE: {
                    trustStoreBuilder.type(value);
                    continue block7;
                }
                case RELATIVE_TO: {
                    trustStoreBuilder.relativeTo(value);
                    continue block7;
                }
                case PASSWORD: {
                    trustStoreBuilder.password(value.toCharArray());
                    credentialSet = true;
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((ConfigurationReader)reader, (int)i);
                }
            }
        }
        Element element = ServerConfigurationParser.nextElement(reader);
        if (element == Element.CREDENTIAL_REFERENCE) {
            if (credentialSet) {
                throw Server.log.cannotOverrideCredential(Element.TRUSTSTORE.toString(), Attribute.PASSWORD.toString());
            }
            trustStoreBuilder.password(this.parseCredentialReference(reader, builder));
            credentialSet = true;
            element = ServerConfigurationParser.nextElement(reader);
        }
        if (!credentialSet && pathSet) {
            throw Server.log.missingCredential(Element.TRUSTSTORE.toString(), Attribute.PASSWORD.toString());
        }
        if (element != null) {
            throw ParseUtils.unexpectedElement((ConfigurationReader)reader, (Enum)element);
        }
    }

    private void parseTrustStoreRealm(ConfigurationReader reader, TrustStoreRealmConfigurationBuilder trustStoreBuilder) {
        String name = "trust";
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((ConfigurationReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((ConfigurationReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((ConfigurationReader)reader);
        trustStoreBuilder.name(name);
    }

    private void parseLegacyTrustStoreRealm(ConfigurationReader reader, ServerConfigurationBuilder builder, TrustStoreRealmConfigurationBuilder trustStoreBuilder, ServerIdentitiesConfigurationBuilder serverIdentitiesConfigurationBuilder) {
        String name = "trust";
        String[] attributes = ParseUtils.requireAttributes((ConfigurationReader)reader, (Enum[])new Enum[]{Attribute.PATH});
        String path = attributes[0];
        String relativeTo = (String)reader.getProperty("infinispan.server.config.path");
        String keyStoreProvider = null;
        InstanceSupplier keyStorePassword = null;
        boolean credentialSet = false;
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((ConfigurationReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block7;
                }
                case PATH: {
                    continue block7;
                }
                case PROVIDER: {
                    keyStoreProvider = value;
                    continue block7;
                }
                case KEYSTORE_PASSWORD: {
                    keyStorePassword = new InstanceSupplier((Object)value.toCharArray());
                    credentialSet = true;
                    continue block7;
                }
                case RELATIVE_TO: {
                    relativeTo = ParseUtils.requireAttributeProperty((ConfigurationReader)reader, (int)i);
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((ConfigurationReader)reader, (int)i);
                }
            }
        }
        Element element = ServerConfigurationParser.nextElement(reader);
        if (element == Element.CREDENTIAL_REFERENCE) {
            if (credentialSet) {
                throw Server.log.cannotOverrideCredential(Element.TRUSTSTORE_REALM.toString(), Attribute.KEYSTORE_PASSWORD.toString());
            }
            keyStorePassword = this.parseCredentialReference(reader, builder);
            credentialSet = true;
            element = ServerConfigurationParser.nextElement(reader);
        }
        if (!credentialSet) {
            throw Server.log.missingCredential(Element.TRUSTSTORE_REALM.toString(), Attribute.KEYSTORE_PASSWORD.toString());
        }
        if (element != null) {
            throw ParseUtils.unexpectedElement((ConfigurationReader)reader, (Enum)element);
        }
        serverIdentitiesConfigurationBuilder.sslConfiguration().trustStore().path(path).relativeTo(relativeTo).password((Supplier<char[]>)keyStorePassword).provider(keyStoreProvider);
        trustStoreBuilder.name(name);
    }

    private void parseKerberos(ConfigurationReader reader, ServerIdentitiesConfigurationBuilder identitiesBuilder) {
        KerberosSecurityFactoryConfigurationBuilder builder = identitiesBuilder.addKerberosConfiguration();
        String[] attributes = ParseUtils.requireAttributes((ConfigurationReader)reader, (Enum[])new Enum[]{Attribute.KEYTAB_PATH, Attribute.PRINCIPAL});
        builder.keyTabPath(attributes[0]);
        builder.principal(attributes[1]);
        block17: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((ConfigurationReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case PRINCIPAL: 
                case KEYTAB_PATH: {
                    continue block17;
                }
                case RELATIVE_TO: {
                    builder.relativeTo(value);
                    continue block17;
                }
                case DEBUG: {
                    builder.debug(Boolean.parseBoolean(value));
                    continue block17;
                }
                case FAIL_CACHE: {
                    builder.failCache(Long.parseLong(value));
                    continue block17;
                }
                case MECHANISM_NAMES: {
                    for (String name : ParseUtils.getListAttributeValue((String)value)) {
                        builder.addMechanismName(name);
                    }
                    continue block17;
                }
                case MECHANISM_OIDS: {
                    for (String oid : ParseUtils.getListAttributeValue((String)value)) {
                        builder.addMechanismOid(oid);
                    }
                    continue block17;
                }
                case MINIMUM_REMAINING_LIFETIME: {
                    builder.minimumRemainingLifetime(Integer.parseInt(value));
                    continue block17;
                }
                case OBTAIN_KERBEROS_TICKET: {
                    builder.obtainKerberosTicket(Boolean.parseBoolean(value));
                    continue block17;
                }
                case REQUEST_LIFETIME: {
                    builder.requestLifetime(Integer.parseInt(value));
                    continue block17;
                }
                case REQUIRED: {
                    builder.checkKeyTab(Boolean.parseBoolean(value));
                    continue block17;
                }
                case SERVER: {
                    builder.server(Boolean.parseBoolean(value));
                    continue block17;
                }
                case WRAP_GSS_CREDENTIAL: {
                    builder.wrapGssCredential(Boolean.parseBoolean(value));
                    continue block17;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((ConfigurationReader)reader, (int)i);
                }
            }
        }
        block20: while (reader.inTag()) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case OPTION: {
                    String[] option = ParseUtils.requireAttributes((ConfigurationReader)reader, (Enum[])new Enum[]{Attribute.NAME, Attribute.VALUE});
                    builder.addOption(option[0], option[1]);
                    continue block20;
                }
            }
            throw ParseUtils.unexpectedElement((ConfigurationReader)reader);
        }
        builder.build(reader.getProperties());
    }

    private void parseDataSources(ConfigurationReader reader, ServerConfigurationBuilder builder) {
        DataSourcesConfigurationBuilder dataSources = builder.dataSources();
        block4: while (reader.inTag()) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case DATA_SOURCES: {
                    this.parseDataSource(reader, element, builder, dataSources);
                    reader.require(ConfigurationReader.ElementType.END_ELEMENT, null, (Enum)Element.DATA_SOURCES);
                    continue block4;
                }
                case DATA_SOURCE: {
                    this.parseDataSource(reader, element, builder, dataSources);
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement((ConfigurationReader)reader);
        }
    }

    private void parseDataSource(ConfigurationReader reader, Element wrapper, ServerConfigurationBuilder builder, DataSourcesConfigurationBuilder dataSourcesBuilder) {
        String[] attributes = ParseUtils.requireAttributes((ConfigurationReader)reader, (Enum[])new Enum[]{Attribute.NAME, Attribute.JNDI_NAME});
        String name = attributes[0];
        String jndiName = attributes[1];
        DataSourceConfigurationBuilder dataSourceBuilder = dataSourcesBuilder.dataSource(name, jndiName);
        block8: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((ConfigurationReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case NAME: 
                case JNDI_NAME: {
                    continue block8;
                }
                case STATISTICS: {
                    dataSourceBuilder.statistics(Boolean.parseBoolean(value));
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((ConfigurationReader)reader, (int)i);
                }
            }
        }
        EnumSet<Element> required = EnumSet.of(Element.CONNECTION_FACTORY);
        block9: while (reader.inTag()) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case CONNECTION_FACTORY: {
                    this.parseDataSourceConnectionFactory(reader, builder, dataSourceBuilder);
                    required.remove((Object)Element.CONNECTION_FACTORY);
                    continue block9;
                }
                case CONNECTION_POOL: {
                    this.parseDataSourceConnectionPool(reader, dataSourceBuilder);
                    continue block9;
                }
            }
            throw ParseUtils.unexpectedElement((ConfigurationReader)reader, (Enum)element);
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequiredElement((ConfigurationReader)reader, required);
        }
    }

    private void parseDataSourceConnectionFactory(ConfigurationReader reader, ServerConfigurationBuilder builder, DataSourceConfigurationBuilder dataSourceBuilder) {
        String[] attributes = ParseUtils.requireAttributes((ConfigurationReader)reader, (Enum[])new Enum[]{Attribute.DRIVER});
        dataSourceBuilder.driver(attributes[0]);
        boolean credentialSet = false;
        block13: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((ConfigurationReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case DRIVER: {
                    continue block13;
                }
                case USERNAME: {
                    dataSourceBuilder.username(value);
                    continue block13;
                }
                case PASSWORD: {
                    dataSourceBuilder.password(value.toCharArray());
                    credentialSet = true;
                    continue block13;
                }
                case URL: {
                    dataSourceBuilder.url(value);
                    continue block13;
                }
                case TRANSACTION_ISOLATION: {
                    dataSourceBuilder.transactionIsolation(AgroalConnectionFactoryConfiguration.TransactionIsolation.valueOf((String)value));
                    continue block13;
                }
                case NEW_CONNECTION_SQL: {
                    dataSourceBuilder.newConnectionSql(value);
                    continue block13;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((ConfigurationReader)reader, (int)i);
                }
            }
        }
        block14: while (reader.inTag()) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case CREDENTIAL_REFERENCE: {
                    if (credentialSet) {
                        throw Server.log.cannotOverrideCredential(Element.CONNECTION_FACTORY.toString(), Attribute.PASSWORD.toString());
                    }
                    dataSourceBuilder.password(this.parseCredentialReference(reader, builder));
                    credentialSet = true;
                    continue block14;
                }
                case CONNECTION_PROPERTIES: {
                    for (int i = 0; i < reader.getAttributeCount(); ++i) {
                        dataSourceBuilder.addProperty(reader.getAttributeName(i), reader.getAttributeValue(i));
                    }
                    ParseUtils.requireNoContent((ConfigurationReader)reader);
                    continue block14;
                }
                case CONNECTION_PROPERTY: {
                    String value;
                    String name = ParseUtils.requireAttributes((ConfigurationReader)reader, (Enum[])new Enum[]{Attribute.NAME})[0];
                    if (reader.getAttributeCount() == 1) {
                        value = reader.getElementText();
                    } else {
                        value = ParseUtils.requireAttributes((ConfigurationReader)reader, (Enum[])new Enum[]{Attribute.VALUE})[0];
                        ParseUtils.requireNoContent((ConfigurationReader)reader);
                    }
                    dataSourceBuilder.addProperty(name, value);
                    continue block14;
                }
            }
            throw ParseUtils.unexpectedElement((ConfigurationReader)reader, (Enum)element);
        }
        if (!credentialSet) {
            throw Server.log.missingCredential(Element.CONNECTION_FACTORY.toString(), Attribute.PASSWORD.toString());
        }
    }

    private void parseDataSourceConnectionPool(ConfigurationReader reader, DataSourceConfigurationBuilder dataSourceBuilder) {
        String[] attributes = ParseUtils.requireAttributes((ConfigurationReader)reader, (Enum[])new Enum[]{Attribute.MAX_SIZE});
        dataSourceBuilder.maxSize(Integer.parseInt(attributes[0]));
        block10: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((ConfigurationReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case MAX_SIZE: {
                    continue block10;
                }
                case MIN_SIZE: {
                    dataSourceBuilder.minSize(Integer.parseInt(value));
                    continue block10;
                }
                case INITIAL_SIZE: {
                    dataSourceBuilder.initialSize(Integer.parseInt(value));
                    continue block10;
                }
                case BLOCKING_TIMEOUT: {
                    dataSourceBuilder.blockingTimeout(Integer.parseInt(value));
                    continue block10;
                }
                case BACKGROUND_VALIDATION: {
                    dataSourceBuilder.backgroundValidation(Long.parseLong(value));
                    continue block10;
                }
                case VALIDATE_ON_ACQUISITION: {
                    dataSourceBuilder.validateOnAcquisition(Long.parseLong(value));
                    continue block10;
                }
                case LEAK_DETECTION: {
                    dataSourceBuilder.leakDetection(Long.parseLong(value));
                    continue block10;
                }
                case IDLE_REMOVAL: {
                    dataSourceBuilder.idleRemoval(Integer.parseInt(value));
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((ConfigurationReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((ConfigurationReader)reader);
    }

    private void parseEndpoints(ConfigurationReader reader, ConfigurationBuilderHolder holder, ServerConfigurationBuilder builder) {
        String defaultSocketBinding = null;
        String defaultSecurityRealm = null;
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            String value = reader.getAttributeValue(i);
            switch (attribute) {
                case SOCKET_BINDING: {
                    defaultSocketBinding = value;
                    continue block4;
                }
                case SECURITY_REALM: {
                    defaultSecurityRealm = value;
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedElement((ConfigurationReader)reader);
                }
            }
        }
        while (reader.inTag()) {
            Element element = Element.forName(reader.getLocalName());
            if (element == Element.ENDPOINT || element == Element.ENDPOINTS) {
                this.parseEndpoint(reader, holder, builder, element, defaultSocketBinding, defaultSecurityRealm);
                continue;
            }
            throw ParseUtils.unexpectedElement((ConfigurationReader)reader);
        }
        if (builder.endpoints().endpoints().isEmpty()) {
            if (defaultSocketBinding == null) {
                throw ParseUtils.missingRequired((ConfigurationReader)reader, Collections.singleton(Attribute.SOCKET_BINDING));
            }
            EndpointConfigurationBuilder endpoint = builder.endpoints().addEndpoint(defaultSocketBinding);
            if (defaultSecurityRealm != null) {
                endpoint.securityRealm(defaultSecurityRealm).implicitConnectorSecurity(true);
            }
            this.configureDefaultEndpoint(reader, defaultSocketBinding, endpoint);
        }
    }

    private void parseEndpoint(ConfigurationReader reader, ConfigurationBuilderHolder holder, ServerConfigurationBuilder builder, Element endpointElement, String defaultSocketBinding, String defaultSecurityRealm) {
        String securityRealm;
        String binding;
        String socketBinding = defaultSocketBinding == null ? ParseUtils.requireAttributes((ConfigurationReader)reader, (Enum[])new Enum[]{Attribute.SOCKET_BINDING})[0] : ((binding = reader.getAttributeValue((Enum)Attribute.SOCKET_BINDING)) != null ? binding : defaultSocketBinding);
        EndpointConfigurationBuilder endpoint = builder.endpoints().addEndpoint(socketBinding);
        String realm = reader.getAttributeValue((Enum)Attribute.SECURITY_REALM);
        String string = securityRealm = realm != null ? realm : defaultSecurityRealm;
        if (securityRealm != null) {
            endpoint.securityRealm(securityRealm).implicitConnectorSecurity(reader.getSchema().since(11, 0));
        }
        block9: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            String value = reader.getAttributeValue(i);
            switch (attribute) {
                case SOCKET_BINDING: 
                case SECURITY_REALM: {
                    continue block9;
                }
                case ADMIN: {
                    endpoint.admin(Boolean.parseBoolean(value));
                    continue block9;
                }
                case METRICS_AUTH: {
                    endpoint.metricsAuth(Boolean.parseBoolean(value));
                    continue block9;
                }
                default: {
                    ServerConfigurationParser.parseCommonConnectorAttributes(reader, i, builder, endpoint.singlePort());
                }
            }
        }
        block10: while (reader.inTag((Enum)endpointElement)) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case IP_FILTER: {
                    ServerConfigurationParser.parseConnectorIpFilter(reader, endpoint.singlePort().ipFilter());
                    continue block10;
                }
                case CONNECTORS: {
                    this.parseConnectors(reader, holder);
                    continue block10;
                }
            }
            reader.handleAny((ConfigurationReaderContext)holder);
        }
        this.configureDefaultEndpoint(reader, socketBinding, endpoint);
    }

    private void parseConnectors(ConfigurationReader reader, ConfigurationBuilderHolder holder) {
        while (reader.inTag((Enum)Element.CONNECTORS)) {
            reader.getMapItem((Enum)Attribute.NAME);
            reader.handleAny((ConfigurationReaderContext)holder);
            reader.endMapItem();
        }
    }

    private void configureDefaultEndpoint(ConfigurationReader reader, String socketBinding, EndpointConfigurationBuilder endpoint) {
        if (endpoint.connectors().isEmpty()) {
            ((HotRodServerConfigurationBuilder)((HotRodServerConfigurationBuilder)endpoint.addConnector(HotRodServerConfigurationBuilder.class).implicitConnector(true)).startTransport(false)).socketBinding(socketBinding);
            RestServerConfigurationBuilder rest = (RestServerConfigurationBuilder)((RestServerConfigurationBuilder)((RestServerConfigurationBuilder)endpoint.addConnector(RestServerConfigurationBuilder.class).implicitConnector(true)).startTransport(false)).socketBinding(socketBinding);
            ServerConfigurationParser.configureEndpoint(reader.getProperties(), endpoint, rest);
        }
    }

    public static void configureEndpoint(Properties properties, EndpointConfigurationBuilder endpoint, RestServerConfigurationBuilder builder) {
        if (endpoint.admin()) {
            String serverHome = properties.getProperty("infinispan.server.home.path");
            builder.staticResources(Paths.get(serverHome, "static"));
        }
        builder.authentication().metricsAuth(endpoint.metricsAuth());
    }

    public static void parseCommonConnectorAttributes(ConfigurationReader reader, int index, ServerConfigurationBuilder serverBuilder, ProtocolServerConfigurationBuilder<?, ?> builder) {
        if (ParseUtils.isNoNamespaceAttribute((ConfigurationReader)reader, (int)index)) {
            Attribute attribute = Attribute.forName(reader.getAttributeName(index));
            String value = reader.getAttributeValue(index);
            switch (attribute) {
                case IDLE_TIMEOUT: {
                    builder.idleTimeout(Integer.parseInt(value));
                    break;
                }
                case IO_THREADS: {
                    builder.ioThreads(Integer.parseInt(value));
                    break;
                }
                case RECEIVE_BUFFER_SIZE: {
                    builder.recvBufSize(Integer.parseInt(value));
                    break;
                }
                case REQUIRE_SSL_CLIENT_AUTH: {
                    builder.ssl().requireClientAuth(Boolean.parseBoolean(value));
                    break;
                }
                case SECURITY_REALM: {
                    break;
                }
                case SEND_BUFFER_SIZE: {
                    builder.sendBufSize(Integer.parseInt(value));
                    break;
                }
                case TCP_KEEPALIVE: {
                    builder.tcpKeepAlive(Boolean.parseBoolean(value));
                    break;
                }
                case TCP_NODELAY: {
                    builder.tcpNoDelay(Boolean.parseBoolean(value));
                    break;
                }
                case WORKER_THREADS: {
                    builder.workerThreads(Integer.parseInt(value));
                    break;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((ConfigurationReader)reader, (int)index);
                }
            }
        }
    }

    public static void parseCommonConnectorElements(ConfigurationReader reader, ProtocolServerConfigurationBuilder<?, ?> builder) {
        Element element = Element.forName(reader.getLocalName());
        switch (element) {
            case IP_FILTER: {
                ServerConfigurationParser.parseConnectorIpFilter(reader, builder.ipFilter());
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((ConfigurationReader)reader);
            }
        }
    }

    private static void parseConnectorIpFilter(ConfigurationReader reader, IpFilterConfigurationBuilder builder) {
        block4: while (reader.inTag()) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ACCEPT: {
                    builder.allowFrom(ParseUtils.requireSingleAttribute((ConfigurationReader)reader, (Enum)Attribute.FROM));
                    ParseUtils.requireNoContent((ConfigurationReader)reader);
                    continue block4;
                }
                case REJECT: {
                    builder.rejectFrom(ParseUtils.requireSingleAttribute((ConfigurationReader)reader, (Enum)Attribute.FROM));
                    ParseUtils.requireNoContent((ConfigurationReader)reader);
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement((ConfigurationReader)reader);
        }
    }

    public void readAttribute(ConfigurationReader reader, String elementName, int attributeIndex, ConfigurationBuilderHolder holder) {
        if (org.infinispan.configuration.parsing.Element.forName((String)elementName) == org.infinispan.configuration.parsing.Element.TRANSPORT) {
            ServerConfigurationBuilder serverBuilder = (ServerConfigurationBuilder)holder.getGlobalConfigurationBuilder().addModule(ServerConfigurationBuilder.class);
            String attributeName = reader.getAttributeName(attributeIndex);
            switch (Attribute.forName(attributeName)) {
                case SECURITY_REALM: {
                    serverBuilder.security().transport().securityRealm(reader.getAttributeValue(attributeIndex));
                    break;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((ConfigurationReader)reader, (String)attributeName);
                }
            }
        } else {
            throw ParseUtils.unexpectedElement((ConfigurationReader)reader, (String)elementName);
        }
    }
}

