/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.security;

import java.util.function.Supplier;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.util.InstanceSupplier;
import org.infinispan.server.configuration.security.KeyStoreConfiguration;
import org.infinispan.server.configuration.security.RealmConfigurationBuilder;
import org.infinispan.server.configuration.security.TrustStoreConfiguration;

public class TrustStoreConfigurationBuilder
implements Builder<TrustStoreConfiguration> {
    private final AttributeSet attributes;
    private final RealmConfigurationBuilder realmBuilder;

    TrustStoreConfigurationBuilder(RealmConfigurationBuilder realmBuilder) {
        this.realmBuilder = realmBuilder;
        this.attributes = TrustStoreConfiguration.attributeDefinitionSet();
    }

    public TrustStoreConfigurationBuilder password(char[] password) {
        this.attributes.attribute(TrustStoreConfiguration.PASSWORD).set((Object)new InstanceSupplier((Object)password));
        return this;
    }

    public TrustStoreConfigurationBuilder password(Supplier<char[]> password) {
        this.attributes.attribute(TrustStoreConfiguration.PASSWORD).set(password);
        return this;
    }

    public TrustStoreConfigurationBuilder path(String path) {
        this.attributes.attribute(TrustStoreConfiguration.PATH).set((Object)path);
        return this;
    }

    public TrustStoreConfigurationBuilder provider(String value) {
        this.attributes.attribute(TrustStoreConfiguration.PROVIDER).set((Object)value);
        return this;
    }

    public TrustStoreConfigurationBuilder type(String value) {
        this.attributes.attribute(KeyStoreConfiguration.TYPE).set((Object)value);
        return this;
    }

    public TrustStoreConfigurationBuilder relativeTo(String relativeTo) {
        this.attributes.attribute(TrustStoreConfiguration.RELATIVE_TO).set((Object)relativeTo);
        return this;
    }

    public TrustStoreConfiguration create() {
        return new TrustStoreConfiguration(this.attributes.protect());
    }

    public TrustStoreConfigurationBuilder read(TrustStoreConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }
}

