/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.api;

import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.RemoteCacheManagerAdmin;
import org.infinispan.client.hotrod.configuration.ClientIntelligence;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.server.test.api.BaseTestClientDriver;
import org.infinispan.server.test.api.TestUser;
import org.infinispan.server.test.core.TestClient;
import org.infinispan.server.test.core.TestServer;

public class HotRodTestClientDriver
extends BaseTestClientDriver<HotRodTestClientDriver> {
    private final TestServer testServer;
    private final TestClient testClient;
    private ConfigurationBuilder clientConfiguration;
    private int port = 11222;

    public HotRodTestClientDriver(TestServer testServer, TestClient testClient) {
        this.testServer = testServer;
        this.testClient = testClient;
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.maxRetries(1).connectionPool().maxActive(1);
        if (testServer.isContainerRunWithDefaultServerConfig()) {
            builder.clientIntelligence(ClientIntelligence.BASIC);
            builder.security().authentication().username(TestUser.ADMIN.getUser()).password(TestUser.ADMIN.getPassword());
        }
        this.clientConfiguration = builder;
    }

    public HotRodTestClientDriver withClientConfiguration(ConfigurationBuilder clientConfiguration) {
        this.clientConfiguration = clientConfiguration;
        return this;
    }

    public HotRodTestClientDriver withMarshaller(Class<? extends Marshaller> marshallerClass) {
        this.clientConfiguration.marshaller(marshallerClass);
        return this;
    }

    public HotRodTestClientDriver withPort(int port) {
        this.port = port;
        return this;
    }

    public <K, V> RemoteCache<K, V> get() {
        RemoteCacheManager remoteCacheManager = this.testClient.registerResource(this.testServer.newHotRodClient(this.clientConfiguration));
        String name = this.testClient.getMethodName(this.qualifier);
        return remoteCacheManager.getCache(name);
    }

    public <K, V> RemoteCache<K, V> create() {
        RemoteCacheManager remoteCacheManager = this.createRemoteCacheManager();
        String name = this.testClient.getMethodName(this.qualifier);
        if (this.serverConfiguration != null) {
            return ((RemoteCacheManagerAdmin)remoteCacheManager.administration().withFlags(this.flags)).getOrCreateCache(name, this.serverConfiguration);
        }
        if (this.mode != null) {
            return ((RemoteCacheManagerAdmin)remoteCacheManager.administration().withFlags(this.flags)).getOrCreateCache(name, "org.infinispan." + this.mode.name());
        }
        return ((RemoteCacheManagerAdmin)remoteCacheManager.administration().withFlags(this.flags)).getOrCreateCache(name, "org.infinispan." + CacheMode.DIST_SYNC.name());
    }

    public RemoteCacheManager createRemoteCacheManager() {
        return this.testClient.registerResource(this.testServer.newHotRodClient(this.clientConfiguration, this.port));
    }

    public HotRodTestClientDriver self() {
        return this;
    }
}

