/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.core;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.model.ContainerNetwork;
import com.github.dockerjava.api.model.Mount;
import com.github.dockerjava.api.model.MountType;
import com.github.dockerjava.api.model.Network;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.test.Eventually;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.commons.test.ThreadLeakChecker;
import org.infinispan.commons.util.StringPropertyReplacer;
import org.infinispan.commons.util.Util;
import org.infinispan.commons.util.Version;
import org.infinispan.server.test.core.AbstractInfinispanServerDriver;
import org.infinispan.server.test.core.CountdownLatchLoggingConsumer;
import org.infinispan.server.test.core.InfinispanGenericContainer;
import org.infinispan.server.test.core.InfinispanServerTestConfiguration;
import org.infinispan.server.test.core.JBossLoggingConsumer;
import org.jboss.logging.BasicLogger;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.OutputFrame;
import org.testcontainers.images.builder.ImageFromDockerfile;
import org.testcontainers.images.builder.dockerfile.DockerfileBuilder;
import org.testcontainers.utility.Base58;

public class ContainerInfinispanServerDriver
extends AbstractInfinispanServerDriver {
    private static final Log log = LogFactory.getLog(ContainerInfinispanServerDriver.class);
    private static final String STARTUP_MESSAGE_REGEX = ".*ISPN080001.*";
    private static final String SHUTDOWN_MESSAGE_REGEX = ".*ISPN080003.*";
    private static final String CLUSTER_VIEW_REGEX = ".*ISPN000094.*(?<=\\()(%d)(?=\\)).*";
    private static final int TIMEOUT_SECONDS = Integer.getInteger("org.infinispan.test.server.container.timeoutSeconds", 45);
    private static final Long IMAGE_MEMORY = Long.getLong("org.infinispan.test.server.container.memory", null);
    private static final Long IMAGE_MEMORY_SWAP = Long.getLong("org.infinispan.test.server.container.memorySwap", null);
    public static final String INFINISPAN_SERVER_HOME = "/opt/infinispan";
    public static final int JMX_PORT = 9999;
    public static final String JDK_BASE_IMAGE_NAME = "registry.access.redhat.com/ubi8/openjdk-11-runtime";
    public static final String IMAGE_USER = "200";
    public static final Integer[] EXPOSED_PORTS = new Integer[]{11222, 11221, 11223, 11224, 11225, 7800, 46655, 9999};
    private final InfinispanGenericContainer[] containers;
    private final String[] volumes;
    private String name;
    ImageFromDockerfile image;

    protected ContainerInfinispanServerDriver(InfinispanServerTestConfiguration configuration) {
        super(configuration, ContainerInfinispanServerDriver.getDockerBridgeAddress());
        this.containers = new InfinispanGenericContainer[configuration.numServers()];
        this.volumes = new String[configuration.numServers()];
    }

    static InetAddress getDockerBridgeAddress() {
        DockerClient dockerClient = DockerClientFactory.instance().client();
        Network bridge = dockerClient.inspectNetworkCmd().withNetworkId("bridge").exec();
        String gateway = ((Network.Ipam.Config)bridge.getIpam().getConfig().get(0)).getGateway();
        return (InetAddress)Exceptions.unchecked(() -> InetAddress.getByName(gateway));
    }

    @Override
    protected void start(String name, File rootDir, File configurationFile) {
        boolean prebuiltImage;
        String imageName;
        String logFile;
        this.name = name;
        String jGroupsStack = System.getProperty("infinispan.cluster.stack");
        ContainerInfinispanServerDriver.createServerHierarchy(rootDir);
        ArrayList<String> args = new ArrayList<String>();
        args.add("bin/server.sh");
        args.add("-c");
        args.add(configurationFile.getName());
        args.add("-b");
        args.add("SITE_LOCAL");
        args.add("-Djgroups.bind.address=SITE_LOCAL");
        if (jGroupsStack != null) {
            args.add("-j");
            args.add(jGroupsStack);
        }
        args.add("-Dinfinispan.cluster.name=" + name);
        args.add("-Dorg.infinispan.test.host.address=" + this.testHostAddress.getHostAddress());
        if (this.configuration.isJMXEnabled()) {
            args.add("-Dcom.sun.management.jmxremote.port=9999");
            args.add("-Dcom.sun.management.jmxremote.authenticate=false");
            args.add("-Dcom.sun.management.jmxremote.ssl=false");
        }
        if ((logFile = System.getProperty("org.infinispan.test.server.container.logFile")) != null) {
            Path logPath = Paths.get(logFile, new String[0]);
            String logFileName = logPath.getFileName().toString();
            if (logPath.isAbsolute()) {
                try {
                    Files.copy(logPath, new File(this.getConfDir(), logFileName).toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    throw new IllegalStateException("Cannot copy the log file", e);
                }
            }
            args.add("-l");
            args.add(logFileName);
        }
        Properties properties = new Properties();
        properties.setProperty("infinispan.server.config.path", Paths.get(INFINISPAN_SERVER_HOME, "conf").toString());
        properties.setProperty("infinispan.cluster.name", name);
        properties.setProperty("org.infinispan.test.host.address", this.testHostAddress.getHostName());
        this.configuration.properties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> args.add("-D" + k + "=" + StringPropertyReplacer.replaceProperties((String)((String)v), (Properties)properties))));
        this.configureSite(args);
        boolean preserveImageAfterTest = Boolean.parseBoolean(this.configuration.properties().getProperty("org.infinispan.test.server.container.preserveImage", "false"));
        Path tmp = Paths.get(CommonsTestingUtil.tmpDirectory(this.getClass()), new String[0]);
        File libDir = new File(rootDir, "lib");
        libDir.mkdirs();
        this.copyArtifactsToUserLibDir(libDir);
        this.image = (ImageFromDockerfile)((ImageFromDockerfile)((ImageFromDockerfile)new ImageFromDockerfile("localhost/testcontainers/" + Base58.randomString((int)16).toLowerCase(), !preserveImageAfterTest).withFileFromPath("test", rootDir.toPath())).withFileFromPath("tmp", tmp)).withFileFromPath("lib", libDir.toPath());
        String baseImageName = this.configuration.properties().getProperty("org.infinispan.test.server.container.baseImageName");
        if (baseImageName == null) {
            String serverOutputDir = this.configuration.properties().getProperty("org.infinispan.test.server.dir");
            if (serverOutputDir == null) {
                imageName = "quay.io/infinispan/server:" + Version.getMajorMinor();
                prebuiltImage = true;
                log.infof("Using prebuilt image '%s'", (Object)imageName);
            } else {
                Path serverOutputPath = Paths.get(serverOutputDir, new String[0]).normalize();
                imageName = JDK_BASE_IMAGE_NAME;
                ((ImageFromDockerfile)((ImageFromDockerfile)this.image.withFileFromPath("target", serverOutputPath.getParent())).withFileFromPath("src", serverOutputPath.getParent().getParent().resolve("src"))).withFileFromPath("build", this.cleanServerDirectory(serverOutputPath));
                prebuiltImage = false;
                log.infof("Using local image from server built at '%s'", (Object)serverOutputPath);
            }
        } else {
            imageName = baseImageName;
            prebuiltImage = true;
            log.infof("Using prebuilt image '%s'", (Object)imageName);
        }
        this.image.withDockerfileFromBuilder(builder -> {
            block10: {
                ((DockerfileBuilder)((DockerfileBuilder)((DockerfileBuilder)((DockerfileBuilder)((DockerfileBuilder)((DockerfileBuilder)builder.from(imageName)).env("INFINISPAN_SERVER_HOME", INFINISPAN_SERVER_HOME)).env("INFINISPAN_VERSION", Version.getVersion())).label("name", "Infinispan Server")).label("version", Version.getVersion())).label("release", Version.getVersion())).label("architecture", "x86_64");
                if (!prebuiltImage) {
                    builder.copy("build", INFINISPAN_SERVER_HOME);
                }
                try {
                    URL resource = ContainerInfinispanServerDriver.class.getResource("/overlay");
                    if (resource == null) break block10;
                    URI overlayUri = resource.toURI();
                    if ("jar".equals(overlayUri.getScheme())) {
                        try (FileSystem fileSystem = FileSystems.newFileSystem(overlayUri, Collections.emptyMap());){
                            Files.walkFileTree(fileSystem.getPath("/overlay", new String[0]), (FileVisitor<? super Path>)new CommonsTestingUtil.CopyFileVisitor(tmp, true, f -> f.setExecutable(true, false)));
                            break block10;
                        }
                    }
                    Files.walkFileTree(Paths.get(overlayUri), (FileVisitor<? super Path>)new CommonsTestingUtil.CopyFileVisitor(tmp, true, f -> f.setExecutable(true, false)));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            ((DockerfileBuilder)((DockerfileBuilder)((DockerfileBuilder)((DockerfileBuilder)builder.copy("test", "/opt/infinispan/server")).copy("tmp", INFINISPAN_SERVER_HOME)).workDir(INFINISPAN_SERVER_HOME)).entryPoint(args.toArray(new String[0]))).expose(EXPOSED_PORTS);
            ((DockerfileBuilder)((DockerfileBuilder)((DockerfileBuilder)((DockerfileBuilder)builder.copy("lib", this.serverPathFrom("lib"))).user("root")).run(new String[]{"chown", "-R", IMAGE_USER, INFINISPAN_SERVER_HOME})).run(new String[]{"chmod", "-R", "g+rw", INFINISPAN_SERVER_HOME})).user(IMAGE_USER);
        });
        int numServers = this.configuration.numServers();
        CountdownLatchLoggingConsumer clusterLatch = new CountdownLatchLoggingConsumer(numServers, String.format(CLUSTER_VIEW_REGEX, numServers));
        if (this.configuration.isParallelStartup()) {
            CountdownLatchLoggingConsumer startupLatch = new CountdownLatchLoggingConsumer(numServers, STARTUP_MESSAGE_REGEX);
            IntStream.range(0, this.configuration.numServers()).forEach(i -> this.createContainer(i, new Consumer[]{startupLatch, clusterLatch}));
            Exceptions.unchecked(() -> startupLatch.await(TIMEOUT_SECONDS, TimeUnit.SECONDS));
        } else {
            for (int i2 = 0; i2 < this.configuration.numServers(); ++i2) {
                CountdownLatchLoggingConsumer startupLatch = new CountdownLatchLoggingConsumer(1, STARTUP_MESSAGE_REGEX);
                this.createContainer(i2, new Consumer[]{startupLatch, clusterLatch});
                Exceptions.unchecked(() -> startupLatch.await(TIMEOUT_SECONDS, TimeUnit.SECONDS));
            }
        }
        Exceptions.unchecked(() -> clusterLatch.await(TIMEOUT_SECONDS, TimeUnit.SECONDS));
    }

    public InfinispanGenericContainer getContainer(int i) {
        if (this.containers.length <= i) {
            throw new IllegalStateException("Container " + i + " has not been initialized");
        }
        return this.containers[i];
    }

    private void configureSite(List<String> args) {
        if (this.configuration.site() == null) {
            return;
        }
        args.add("-Drelay.site_name=" + this.configuration.site());
        args.add("-Djgroups.cluster.mcast_port=" + this.configuration.siteDiscoveryPort());
    }

    private Path cleanServerDirectory(Path serverOutputPath) {
        Util.recursiveFileRemove((String)serverOutputPath.resolve("server").resolve("data").toString());
        Util.recursiveFileRemove((String)serverOutputPath.resolve("server").resolve("log").toString());
        return serverOutputPath;
    }

    private GenericContainer<?> createContainer(int i, Consumer<OutputFrame> ... logConsumers) {
        if (this.volumes[i] == null) {
            String volumeName = UUID.randomUUID().toString();
            DockerClientFactory.instance().client().createVolumeCmd().withName(volumeName).exec();
            this.volumes[i] = volumeName;
        }
        GenericContainer container = new GenericContainer((Future)this.image).withCreateContainerCmdModifier(cmd -> {
            cmd.getHostConfig().withMounts(Arrays.asList(new Mount().withSource(this.volumes[i]).withTarget(this.serverPath()).withType(MountType.VOLUME)));
            if (IMAGE_MEMORY != null) {
                cmd.getHostConfig().withMemory(IMAGE_MEMORY);
            }
            if (IMAGE_MEMORY_SWAP != null) {
                cmd.getHostConfig().withMemorySwap(IMAGE_MEMORY_SWAP);
            }
        });
        String debug = this.configuration.properties().getProperty("org.infinispan.test.server.container.debug");
        if (debug != null && Integer.parseInt(debug) == i) {
            String option = this.debugJvmOption();
            container.withEnv("JAVA_OPTS", option);
            log.infof("Container debug enabled with options '%s'%n", (Object)option);
        }
        container.withLogConsumer((Consumer)((Object)new JBossLoggingConsumer((BasicLogger)org.infinispan.util.logging.LogFactory.getLogger((String)this.name)).withPrefix(Integer.toString(i))));
        for (Consumer<OutputFrame> consumer : logConsumers) {
            container.withLogConsumer(consumer);
        }
        log.infof("Starting container %d", (Object)i);
        container.start();
        this.containers[i] = new InfinispanGenericContainer(container);
        log.infof("Started container %d", (Object)i);
        return container;
    }

    @Override
    protected void stop() {
        for (int i = 0; i < this.containers.length; ++i) {
            log.infof("Stopping container %d", (Object)i);
            this.stop(i);
            log.infof("Stopped container %d", (Object)i);
        }
        ThreadLeakChecker.ignoreThreadsContaining((String)"docker-java-stream-");
    }

    @Override
    public boolean isRunning(int server) {
        return this.containers[server].isRunning();
    }

    @Override
    public InetSocketAddress getServerSocket(int server, int port) {
        return new InetSocketAddress(this.getServerAddress(server), port);
    }

    @Override
    public InetAddress getServerAddress(int server) {
        InfinispanGenericContainer container = this.containers[server];
        return container.getIpAddress();
    }

    @Override
    public void pause(int server) {
        InfinispanGenericContainer container = this.containers[server];
        container.pause();
        Eventually.eventually((String)"Container wasn't paused.", () -> container.isPaused());
        System.out.printf("[%d] PAUSE %n", server);
    }

    @Override
    public void resume(int server) {
        InfinispanGenericContainer container = this.containers[server];
        container.resume();
        Eventually.eventually((String)"Container didn't resume.", () -> this.isRunning(server));
        System.out.printf("[%d] RESUME %n", server);
    }

    @Override
    public void stop(int server) {
        InfinispanGenericContainer container = this.containers[server];
        if (container != null) {
            CountdownLatchLoggingConsumer latch = new CountdownLatchLoggingConsumer(1, SHUTDOWN_MESSAGE_REGEX);
            container.withLogConsumer(latch);
            container.stop();
            Eventually.eventually((String)"Container wasn't stopped.", () -> !this.isRunning(server));
            System.out.printf("[%d] STOP %n", server);
        }
    }

    @Override
    public void kill(int server) {
        InfinispanGenericContainer container = this.containers[server];
        if (container != null) {
            container.kill();
            Eventually.eventually((String)"Container wasn't killed.", () -> !this.isRunning(server));
            System.out.printf("[%d] KILL %n", server);
        }
    }

    @Override
    public void restart(int server) {
        if (this.isRunning(server)) {
            throw new IllegalStateException("Server " + server + " is still running");
        }
        CountdownLatchLoggingConsumer startupLatch = new CountdownLatchLoggingConsumer(1, STARTUP_MESSAGE_REGEX);
        this.stop(server);
        log.infof("Restarting container %d", (Object)server);
        this.createContainer(server, new Consumer[]{startupLatch});
        Exceptions.unchecked(() -> startupLatch.await(TIMEOUT_SECONDS, TimeUnit.SECONDS));
    }

    @Override
    public void restartCluster() {
        for (int i = 0; i < this.configuration.numServers(); ++i) {
            this.restart(i);
        }
    }

    @Override
    public MBeanServerConnection getJmxConnection(int server) {
        return (MBeanServerConnection)Exceptions.unchecked(() -> {
            InfinispanGenericContainer container = this.containers[server];
            ContainerNetwork network = container.getContainerNetwork();
            JMXServiceURL url = new JMXServiceURL(String.format("service:jmx:rmi:///jndi/rmi://%s:%d/jmxrmi", network.getIpAddress(), 9999));
            JMXConnector jmxConnector = JMXConnectorFactory.connect(url);
            return jmxConnector.getMBeanServerConnection();
        });
    }

    @Override
    public int getTimeout() {
        return TIMEOUT_SECONDS;
    }

    private String serverPath() {
        return String.format("%s/server", INFINISPAN_SERVER_HOME);
    }

    private String serverPathFrom(String path) {
        return String.format("%s/%s", this.serverPath(), path);
    }

    @Override
    public String syncFilesFromServer(int server, String path) {
        String string;
        block12: {
            String serverPath = Paths.get(path, new String[0]).isAbsolute() ? path : "/opt/infinispan/server/" + path;
            InputStream is = DockerClientFactory.instance().client().copyArchiveFromContainerCmd(this.containers[server].getContainerId(), serverPath).exec();
            try {
                TarArchiveInputStream tar = new TarArchiveInputStream(is);
                Path basePath = this.getRootDir().toPath().resolve(Integer.toString(server));
                Util.recursiveFileRemove((Path)basePath.resolve(path));
                TarArchiveEntry entry = tar.getNextTarEntry();
                while (entry != null) {
                    Path entryPath = basePath.resolve(entry.getName());
                    if (entry.isDirectory()) {
                        entryPath.toFile().mkdirs();
                    } else {
                        OutputStream os = Files.newOutputStream(entryPath, new OpenOption[0]);
                        int b = tar.read();
                        while (b >= 0) {
                            os.write(b);
                            b = tar.read();
                        }
                        Util.close((AutoCloseable)os);
                    }
                    entry = tar.getNextTarEntry();
                }
                string = basePath.toString();
                if (is == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            is.close();
        }
        return string;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public String syncFilesToServer(int server, String path) {
        Path local = Paths.get(path, new String[0]);
        final Path parent = local.getParent();
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            String string;
            try (final TarArchiveOutputStream tar = new TarArchiveOutputStream((OutputStream)bos);){
                Files.walkFileTree(local, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                        Path relativize = parent.relativize(dir);
                        TarArchiveEntry entry = new TarArchiveEntry(dir.toFile(), relativize.toString());
                        entry.setMode(16895);
                        tar.putArchiveEntry((ArchiveEntry)entry);
                        tar.closeArchiveEntry();
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Path relativize = parent.relativize(file);
                        TarArchiveEntry entry = new TarArchiveEntry(file.toFile(), relativize.toString());
                        entry.setMode(33206);
                        tar.putArchiveEntry((ArchiveEntry)entry);
                        try (InputStream is = Files.newInputStream(file, new OpenOption[0]);){
                            int b = is.read();
                            while (b >= 0) {
                                tar.write(b);
                                b = is.read();
                            }
                        }
                        tar.closeArchiveEntry();
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFileFailed(Path file, IOException exc) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                        return FileVisitResult.CONTINUE;
                    }
                });
                tar.close();
                DockerClientFactory.instance().client().copyArchiveToContainerCmd(this.containers[server].getContainerId()).withTarInputStream((InputStream)new ByteArrayInputStream(bos.toByteArray())).withRemotePath("/tmp").exec();
                string = Paths.get("/tmp", new String[0]).resolve(local.getFileName()).toString();
            }
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

