/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.junit4;

import java.util.ArrayList;
import java.util.List;
import org.infinispan.server.test.core.TestServer;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class InfinispanXSiteServerRule
implements TestRule {
    private final List<TestServer> testServers;

    public InfinispanXSiteServerRule(List<TestServer> testServers) {
        this.testServers = testServers;
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                ArrayList servers = new ArrayList();
                String testName = description.getTestClass().getName();
                try {
                    InfinispanXSiteServerRule.this.testServers.forEach(testServer -> {
                        if (!testServer.isDriverInitialized()) {
                            servers.add(testServer);
                            testServer.initServerDriver();
                            testServer.beforeListeners();
                            testServer.getDriver().prepare(testName);
                            testServer.getDriver().start(testName);
                        }
                    });
                    base.evaluate();
                }
                finally {
                    servers.forEach(testServer -> {
                        testServer.getDriver().stop(testName);
                        testServer.afterListeners();
                    });
                }
            }
        };
    }

    public List<TestServer> getTestServers() {
        return this.testServers;
    }
}

