/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.embedded.support;

import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.spring.embedded.AbstractEmbeddedCacheManagerFactory;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class InfinispanEmbeddedCacheManagerFactoryBean
extends AbstractEmbeddedCacheManagerFactory
implements FactoryBean<EmbeddedCacheManager>,
InitializingBean,
DisposableBean {
    private static final Log logger = LogFactory.getLog(InfinispanEmbeddedCacheManagerFactoryBean.class);
    private EmbeddedCacheManager cacheManager;

    public void afterPropertiesSet() throws Exception {
        logger.info((Object)"Initializing Infinispan EmbeddedCacheManager instance ...");
        this.cacheManager = this.createBackingEmbeddedCacheManager();
        logger.info((Object)("Successfully initialized Infinispan EmbeddedCacheManager instance [" + String.valueOf(this.cacheManager) + "]"));
    }

    public EmbeddedCacheManager getObject() throws Exception {
        return this.cacheManager;
    }

    public Class<? extends EmbeddedCacheManager> getObjectType() {
        return this.cacheManager != null ? this.cacheManager.getClass() : EmbeddedCacheManager.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void destroy() throws Exception {
        if (this.cacheManager != null) {
            this.cacheManager.stop();
        }
    }
}

