/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.store.migrator.jdbc;

import java.util.Iterator;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.persistence.jdbc.common.connectionfactory.ConnectionFactory;
import org.infinispan.persistence.jdbc.common.impl.connectionfactory.PooledConnectionFactory;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfiguration;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.impl.table.DbMetaData;
import org.infinispan.persistence.jdbc.impl.table.TableManager;
import org.infinispan.persistence.jdbc.impl.table.TableManagerFactory;
import org.infinispan.persistence.keymappers.DefaultTwoWayKey2StringMapper;
import org.infinispan.persistence.keymappers.TwoWayKey2StringMapper;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.tools.store.migrator.Element;
import org.infinispan.tools.store.migrator.StoreIterator;
import org.infinispan.tools.store.migrator.StoreProperties;
import org.infinispan.tools.store.migrator.StoreType;
import org.infinispan.tools.store.migrator.jdbc.BinaryJdbcIterator;
import org.infinispan.tools.store.migrator.jdbc.JdbcConfigurationUtil;
import org.infinispan.tools.store.migrator.jdbc.MixedJdbcIterator;
import org.infinispan.tools.store.migrator.jdbc.StringJdbcIterator;
import org.infinispan.tools.store.migrator.jdbc.StringJdbcIterator10;
import org.infinispan.tools.store.migrator.marshaller.SerializationConfigUtil;

public class JdbcStoreReader
implements StoreIterator {
    private final StoreProperties props;
    private final Marshaller marshaller;
    private final JdbcStringBasedStoreConfiguration config;
    private final ConnectionFactory connectionFactory;
    private final DbMetaData metaData;
    private final JdbcStringBasedStoreConfiguration stringConfig;
    private final JdbcStringBasedStoreConfiguration binaryConfig;

    public JdbcStoreReader(StoreProperties props) {
        this.props = props;
        this.marshaller = SerializationConfigUtil.getMarshaller(props);
        this.config = JdbcConfigurationUtil.getStoreConfig(props);
        this.connectionFactory = new PooledConnectionFactory();
        this.stringConfig = this.config;
        this.binaryConfig = this.createBinaryTableConfig();
        this.connectionFactory.start(this.config.connectionFactory(), JdbcStoreReader.class.getClassLoader());
        String segmentCount = props.get(Element.SEGMENT_COUNT);
        this.metaData = TableManagerFactory.getDbMetaData((ConnectionFactory)this.connectionFactory, (JdbcStringBasedStoreConfiguration)this.config, (segmentCount == null || Integer.parseInt(segmentCount) <= 0 ? 1 : 0) != 0);
    }

    @Override
    public void close() {
        this.connectionFactory.stop();
    }

    @Override
    public Iterator<MarshallableEntry> iterator() {
        switch (this.props.storeType()) {
            case JDBC_BINARY: {
                return new BinaryJdbcIterator(this.connectionFactory, this.getTableManager(true), this.marshaller);
            }
            case JDBC_STRING: {
                return this.props.getMajorVersion() > 9 ? new StringJdbcIterator10(this.connectionFactory, this.getTableManager(false), this.marshaller, this.getTwoWayMapper()) : new StringJdbcIterator(this.connectionFactory, this.getTableManager(false), this.marshaller, this.getTwoWayMapper());
            }
            case JDBC_MIXED: {
                return new MixedJdbcIterator(this.connectionFactory, this.getTableManager(true), this.getTableManager(false), this.marshaller, this.getTwoWayMapper());
            }
        }
        throw new CacheConfigurationException("Unknown Store Type: " + this.props.storeType());
    }

    private TableManager getTableManager(boolean binary) {
        JdbcStringBasedStoreConfiguration config = binary ? this.binaryConfig : this.stringConfig;
        return TableManagerFactory.getManager((DbMetaData)this.metaData, null, (ConnectionFactory)this.connectionFactory, (JdbcStringBasedStoreConfiguration)config, (String)this.props.cacheName());
    }

    private JdbcStringBasedStoreConfiguration createBinaryTableConfig() {
        if (this.props.storeType() == StoreType.JDBC_STRING) {
            return null;
        }
        JdbcStringBasedStoreConfigurationBuilder builder = (JdbcStringBasedStoreConfigurationBuilder)new ConfigurationBuilder().persistence().addStore(JdbcStringBasedStoreConfigurationBuilder.class);
        JdbcConfigurationUtil.createTableConfig(this.props, Element.BINARY, builder);
        return builder.create();
    }

    private TwoWayKey2StringMapper getTwoWayMapper() {
        String mapperClass = this.config.key2StringMapper();
        if (mapperClass != null) {
            ClassLoader classLoader = JdbcConfigurationUtil.class.getClassLoader();
            try {
                return (TwoWayKey2StringMapper)Util.loadClass((String)mapperClass, (ClassLoader)classLoader).newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new CacheConfigurationException(String.format("Unabled to load TwoWayKey2StringMapper '%s' for %s store", new Object[]{mapperClass, Element.SOURCE}), (Throwable)e);
            }
        }
        return new DefaultTwoWayKey2StringMapper();
    }
}

