/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.assigners;

import java.lang.reflect.Field;
import org.instancio.assignment.AssignmentType;
import org.instancio.assignment.OnSetFieldError;
import org.instancio.exception.InstancioApiException;
import org.instancio.internal.assigners.Assigner;
import org.instancio.internal.assigners.AssignerErrorUtil;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.internal.util.ExceptionHandler;
import org.instancio.internal.util.Format;
import org.instancio.settings.Keys;
import org.instancio.settings.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldAssigner
implements Assigner {
    private static final Logger LOG = LoggerFactory.getLogger(FieldAssigner.class);
    private final OnSetFieldError onSetFieldError;

    public FieldAssigner(Settings settings) {
        this.onSetFieldError = settings.get(Keys.ON_SET_FIELD_ERROR);
        LOG.trace("{}, {}", (Object)AssignmentType.FIELD, (Object)this.onSetFieldError);
    }

    @Override
    public void assign(InternalNode node, Object target, Object value) {
        Field field = node.getField();
        if (value != null) {
            this.setField(target, field, value);
        } else if (!field.getType().isPrimitive()) {
            this.setField(target, field, null);
        }
    }

    private void setField(Object target, Field field, Object value) {
        try {
            field.setAccessible(true);
            field.set(target, value);
        }
        catch (IllegalArgumentException ex) {
            String msg = AssignerErrorUtil.getFieldAssignmentErrorMessage(value, Format.formatField(field), ex);
            throw new InstancioApiException(msg, ex);
        }
        catch (Exception ex) {
            this.handleError(field, value, ex);
        }
    }

    private void handleError(Field field, Object value, Exception ex) {
        if (this.onSetFieldError == OnSetFieldError.FAIL) {
            String msg = AssignerErrorUtil.getFieldAssignmentErrorMessage(value, Format.formatField(field), ex);
            throw new InstancioApiException(msg, ex);
        }
        if (this.onSetFieldError == OnSetFieldError.IGNORE) {
            ExceptionHandler.logException("{}: error assigning value to field: {}", ex, new Object[]{OnSetFieldError.IGNORE, field});
        }
    }
}

