/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator;

import java.util.List;
import java.util.Optional;
import org.instancio.generator.AfterGenerate;
import org.instancio.generator.Generator;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.GeneratorSpec;
import org.instancio.generators.Generators;
import org.instancio.internal.generator.misc.GeneratorDecorator;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.internal.nodes.NodeImpl;
import org.instancio.internal.spi.ProviderEntry;
import org.instancio.settings.Keys;
import org.instancio.spi.GeneratorProvider;
import org.instancio.spi.InstancioServiceProvider;
import org.instancio.spi.InstancioSpiException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GeneratorProviderFacade {
    private static final Logger LOG = LoggerFactory.getLogger(GeneratorProviderFacade.class);
    private final GeneratorContext context;
    private final Generators generators;
    private final List<GeneratorProvider> generatorProviders;
    private final List<ProviderEntry<InstancioServiceProvider.GeneratorProvider>> providerEntries;
    private final AfterGenerate afterGenerate;

    GeneratorProviderFacade(GeneratorContext context, List<GeneratorProvider> generatorProviders, List<ProviderEntry<InstancioServiceProvider.GeneratorProvider>> providerEntries) {
        this.context = context;
        this.generators = new Generators(context);
        this.generatorProviders = generatorProviders;
        this.afterGenerate = context.getSettings().get(Keys.AFTER_GENERATE_HINT);
        this.providerEntries = providerEntries;
    }

    Optional<Generator<?>> getGenerator(InternalNode node) {
        Generator<?> result = this.resolveViaNewSPI(node);
        if (result == null) {
            result = this.resolveViaDeprecatedSPI(node);
        }
        return Optional.ofNullable(result);
    }

    private Generator<?> resolveViaDeprecatedSPI(InternalNode node) {
        Class<?> forClass = node.getTargetClass();
        for (GeneratorProvider provider : this.generatorProviders) {
            Generator<?> generator = provider.getGenerators(this.context).get(forClass);
            if (generator == null) continue;
            LOG.trace("Custom generator '{}' found for {}", (Object)generator.getClass().getName(), forClass);
            return GeneratorDecorator.decorate(generator, this.afterGenerate);
        }
        return null;
    }

    private Generator<?> resolveViaNewSPI(InternalNode internalNode) {
        NodeImpl node = new NodeImpl(internalNode.getTargetClass(), internalNode.getField());
        for (ProviderEntry<InstancioServiceProvider.GeneratorProvider> entry : this.providerEntries) {
            GeneratorSpec<?> spec = entry.getProvider().getGenerator(node, this.generators);
            if (spec == null) continue;
            GeneratorProviderFacade.validateSpec(entry, spec);
            Generator generator = (Generator)spec;
            LOG.trace("Custom generator '{}' found for {}", (Object)generator.getClass().getName(), (Object)node);
            return GeneratorDecorator.decorate(generator, this.afterGenerate);
        }
        return null;
    }

    private static void validateSpec(ProviderEntry<InstancioServiceProvider.GeneratorProvider> entry, GeneratorSpec<?> spec) {
        if (spec instanceof Generator) {
            return;
        }
        throw new InstancioSpiException(String.format("The GeneratorSpec %s returned by %s must implement %s", spec.getClass(), entry.getInstancioProviderClass(), Generator.class));
    }
}

