/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator;

import java.util.List;
import java.util.Optional;
import org.instancio.generator.Generator;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.SubtypeGeneratorSpec;
import org.instancio.internal.generator.GeneratorProviderFacade;
import org.instancio.internal.generator.GeneratorResolverMaps;
import org.instancio.internal.generator.GeneratorUtil;
import org.instancio.internal.generator.array.ArrayGenerator;
import org.instancio.internal.generator.lang.EnumGenerator;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.internal.spi.ProviderEntry;
import org.instancio.internal.util.ReflectionUtils;
import org.instancio.internal.util.ServiceLoaders;
import org.instancio.spi.GeneratorProvider;
import org.instancio.spi.InstancioServiceProvider;
import org.jetbrains.annotations.Nullable;

public class GeneratorResolver {
    private static final List<GeneratorProvider> DEPRECATED_PROVIDERS = ServiceLoaders.loadAll(GeneratorProvider.class);
    private final GeneratorContext context;
    private final GeneratorProviderFacade generatorProviderFacade;

    public GeneratorResolver(GeneratorContext context, List<ProviderEntry<InstancioServiceProvider.GeneratorProvider>> providerEntries) {
        this.context = context;
        this.generatorProviderFacade = new GeneratorProviderFacade(context, DEPRECATED_PROVIDERS, providerEntries);
    }

    private static Generator<?> loadByClassName(GeneratorContext context, String generateTypeClassName, String generatorClassName) {
        Class<?> targetClass = ReflectionUtils.loadClass(generateTypeClassName);
        Class<?> generatorClass = ReflectionUtils.loadClass(generatorClassName);
        if (targetClass == null || generatorClass == null) {
            return null;
        }
        return GeneratorUtil.instantiateInternalGenerator(generatorClass, context);
    }

    public Optional<Generator<?>> get(InternalNode node) {
        Class<?> klass = node.getTargetClass();
        Optional<Generator<?>> spiGenerator = this.generatorProviderFacade.getGenerator(node);
        if (spiGenerator.isPresent()) {
            return spiGenerator;
        }
        Generator<?> generator = this.getBuiltInGenerator(klass);
        if (generator == null) {
            generator = klass.isArray() ? new ArrayGenerator(this.context, klass) : (klass.isEnum() ? new EnumGenerator(this.context, klass) : this.getGeneratorForLegacyClass(klass));
        }
        return Optional.ofNullable(generator);
    }

    @Nullable
    private Generator<?> getGeneratorForLegacyClass(Class<?> klass) {
        if ("java.sql.Date".equals(klass.getName())) {
            return GeneratorResolver.loadByClassName(this.context, "java.sql.Date", "org.instancio.internal.generator.sql.SqlDateGenerator");
        }
        if ("java.sql.Timestamp".equals(klass.getName())) {
            return GeneratorResolver.loadByClassName(this.context, "java.sql.Timestamp", "org.instancio.internal.generator.sql.TimestampGenerator");
        }
        if ("javax.xml.datatype.XMLGregorianCalendar".equals(klass.getName())) {
            return GeneratorResolver.loadByClassName(this.context, "javax.xml.datatype.XMLGregorianCalendar", "org.instancio.internal.generator.xml.XMLGregorianCalendarGenerator");
        }
        return null;
    }

    private Generator<?> getBuiltInGenerator(Class<?> targetClass) {
        Class<?> subtype;
        Class<?> genClass = GeneratorResolverMaps.getGenerator(targetClass);
        if (genClass == null) {
            return null;
        }
        Generator<?> generator = GeneratorUtil.instantiateInternalGenerator(genClass, this.context);
        if (generator instanceof SubtypeGeneratorSpec && (subtype = GeneratorResolverMaps.getSubtype(targetClass)) != null) {
            ((SubtypeGeneratorSpec)((Object)generator)).subtype(subtype);
        }
        return generator;
    }
}

