/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.time;

import java.time.Month;
import java.time.MonthDay;
import org.instancio.Random;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.MonthDayGeneratorSpec;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.generator.AbstractGenerator;

public class MonthDayGenerator
extends AbstractGenerator<MonthDay>
implements MonthDayGeneratorSpec {
    private MonthDay min = MonthDay.of(1, 1);
    private MonthDay max = MonthDay.of(12, 31);

    public MonthDayGenerator(GeneratorContext context) {
        super(context);
    }

    @Override
    public String apiMethod() {
        return "monthDay()";
    }

    @Override
    public MonthDayGeneratorSpec min(MonthDay min) {
        this.min = ApiValidator.notNull(min, "'min' must not be null", new Object[0]);
        return this;
    }

    @Override
    public MonthDayGeneratorSpec max(MonthDay max) {
        this.max = ApiValidator.notNull(max, "'max' must not be null", new Object[0]);
        return this;
    }

    @Override
    public MonthDayGeneratorSpec range(MonthDay min, MonthDay max) {
        this.min = ApiValidator.notNull(min, "MonthDay start must not be null", new Object[0]);
        this.max = ApiValidator.notNull(max, "MonthDay end must not be null", new Object[0]);
        ApiValidator.isTrue(min.compareTo(max) <= 0, "Start must not exceed end: %s, %s", this.min, this.max);
        return this;
    }

    @Override
    protected MonthDay tryGenerateNonNull(Random random) {
        int minMonth = this.min.getMonthValue();
        int maxMonth = this.max.getMonthValue();
        int month = random.intRange(minMonth, maxMonth);
        int minDay = 1;
        int maxDay = 31;
        if (month == minMonth) {
            minDay = this.min.getDayOfMonth();
            maxDay = Math.max(minDay, this.max.getDayOfMonth());
        } else if (month == maxMonth) {
            maxDay = this.max.getDayOfMonth();
        }
        int day = random.intRange(minDay, maxDay);
        return MonthDay.of(month, Math.min(day, Month.of(month).maxLength()));
    }
}

