/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.selectors;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.instancio.PredicateSelector;
import org.instancio.TargetSelector;
import org.instancio.exception.InstancioException;
import org.instancio.internal.selectors.Flattener;
import org.instancio.internal.selectors.SelectorTargetKind;
import org.instancio.internal.selectors.UnusedSelectorDescription;
import org.instancio.internal.util.Format;
import org.instancio.internal.util.ObjectUtils;
import org.jetbrains.annotations.Nullable;

public final class PredicateSelectorImpl
implements PredicateSelector,
Flattener,
UnusedSelectorDescription {
    private static final Predicate<Field> NON_NULL_FIELD = Objects::nonNull;
    private static final Predicate<Class<?>> NON_NULL_TYPE = Objects::nonNull;
    private final SelectorTargetKind selectorTargetKind;
    private final Predicate<Field> fieldPredicate;
    private final Predicate<Class<?>> classPredicate;
    private final String apiInvocationDescription;
    private final Throwable stackTraceHolder;

    public PredicateSelectorImpl(SelectorTargetKind selectorTargetKind, @Nullable Predicate<Field> fieldPredicate, @Nullable Predicate<Class<?>> classPredicate, @Nullable String apiInvocationDescription) {
        this(selectorTargetKind, fieldPredicate, classPredicate, apiInvocationDescription, new Throwable());
    }

    PredicateSelectorImpl(SelectorTargetKind selectorTargetKind, @Nullable Predicate<Field> fieldPredicate, @Nullable Predicate<Class<?>> classPredicate, @Nullable String apiInvocationDescription, Throwable stackTraceHolder) {
        this.selectorTargetKind = selectorTargetKind;
        this.fieldPredicate = fieldPredicate == null ? null : NON_NULL_FIELD.and(fieldPredicate);
        this.classPredicate = classPredicate == null ? null : NON_NULL_TYPE.and(classPredicate);
        this.apiInvocationDescription = apiInvocationDescription;
        this.stackTraceHolder = stackTraceHolder;
    }

    @Override
    public List<TargetSelector> flatten() {
        return Collections.singletonList(this);
    }

    @Override
    public String getDescription() {
        return String.format("%s%n    at %s", this, Format.firstNonInstancioStackTraceLine(this.stackTraceHolder));
    }

    public SelectorTargetKind getSelectorTargetKind() {
        return this.selectorTargetKind;
    }

    public Predicate<Field> getFieldPredicate() {
        return this.fieldPredicate;
    }

    public Predicate<Class<?>> getClassPredicate() {
        return this.classPredicate;
    }

    private String buildCustomPredicateToString() {
        if (this.selectorTargetKind == SelectorTargetKind.FIELD) {
            return "fields(Predicate<Field>)";
        }
        if (this.selectorTargetKind == SelectorTargetKind.CLASS) {
            return "types(Predicate<Class>)";
        }
        throw new InstancioException("Unknown selector kind: " + (Object)((Object)this.selectorTargetKind));
    }

    public String toString() {
        return ObjectUtils.defaultIfNull(this.apiInvocationDescription, this::buildCustomPredicateToString);
    }
}

