/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.util;

import java.util.Optional;
import java.util.function.Supplier;
import org.instancio.exception.InstancioApiException;
import org.instancio.exception.InstancioException;
import org.instancio.internal.util.Constants;
import org.instancio.internal.util.SystemProperties;
import org.instancio.internal.util.VoidFunction;
import org.jetbrains.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;

public final class ExceptionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ExceptionHandler.class);
    private static final String ERROR_MSG = String.format("Suppressed error because system property '%s' is disabled", "instancio.failOnError");

    private ExceptionHandler() {
    }

    public static <T> Optional<T> conditionalFailOnError(Supplier<T> supplier) {
        try {
            return Optional.ofNullable(supplier.get());
        }
        catch (InstancioApiException ex) {
            throw ex;
        }
        catch (InstancioException ex) {
            if (SystemProperties.isFailOnError()) {
                throw ex;
            }
            ExceptionHandler.logSuppressed(ex);
        }
        catch (Exception ex) {
            if (SystemProperties.isFailOnError()) {
                throw InstancioException.unhandledException(ex);
            }
            ExceptionHandler.logSuppressed(ex);
        }
        return Optional.empty();
    }

    public static void conditionalFailOnError(VoidFunction function) {
        try {
            function.invoke();
        }
        catch (InstancioApiException ex) {
            throw ex;
        }
        catch (InstancioException ex) {
            if (SystemProperties.isFailOnError()) {
                throw ex;
            }
            ExceptionHandler.logSuppressed(ex);
        }
        catch (Throwable ex) {
            if (SystemProperties.isFailOnError()) {
                throw InstancioException.unhandledException(ex);
            }
            ExceptionHandler.logSuppressed(ex);
        }
    }

    private static void logSuppressed(Throwable t) {
        if (LOG.isTraceEnabled()) {
            LOG.trace(ERROR_MSG, t);
        } else {
            LOG.debug("{}. {}: {}", new Object[]{ERROR_MSG, t.getClass().getName(), t.getMessage()});
        }
    }

    public static void logException(String msg, Throwable t, Object ... args) {
        String formatted = MessageFormatter.arrayFormat((String)msg, (Object[])args).getMessage();
        if (LOG.isTraceEnabled()) {
            LOG.trace(formatted, t);
        } else {
            LOG.debug("{} [{}]", (Object)formatted, (Object)ExceptionHandler.getCausedBy(t));
        }
    }

    public static void runIgnoringTheNoClassDefFoundError(Runnable action) {
        try {
            action.run();
        }
        catch (NoClassDefFoundError error) {
            LOG.debug("Error is ignored: {}", (Object)error.toString());
        }
    }

    @VisibleForTesting
    static String getCausedBy(Throwable throwable) {
        StringBuilder sb = new StringBuilder();
        for (Throwable t = throwable; t != null; t = t.getCause()) {
            sb.append(Constants.NL).append(" => caused by: ").append(t.getClass().getSimpleName());
            if (t.getMessage() == null) continue;
            sb.append(": \"").append(t.getMessage()).append('\"');
        }
        return sb.toString();
    }
}

