/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.assigners;

import java.lang.reflect.Field;
import org.instancio.assignment.AssignmentType;
import org.instancio.assignment.OnSetFieldError;
import org.instancio.assignment.OnSetMethodError;
import org.instancio.assignment.OnSetMethodNotFound;
import org.instancio.assignment.SetterStyle;
import org.instancio.internal.util.Constants;
import org.instancio.internal.util.Format;
import org.instancio.internal.util.StringUtils;
import org.instancio.settings.Keys;
import org.instancio.settings.Settings;

final class AssignerErrorUtil {
    private static final int INITIAL_SB_SIZE = 1024;

    private AssignerErrorUtil() {
    }

    static String getIncompatibleTypesErrorMessage(Object value, Field field, Throwable cause) {
        String fieldName = Format.formatField(field);
        String argType = Format.withoutPackage(value.getClass());
        String argValue = StringUtils.quoteToString(value);
        Throwable rootCause = AssignerErrorUtil.getRootCause(cause);
        return new StringBuilder(1024).append("error assigning value to field due to incompatible types").append(Constants.NL).append(Constants.NL).append(" -> Field ....................: ").append(fieldName).append(Constants.NL).append(" -> Provided argument type ...: ").append(argType).append(Constants.NL).append(" -> Provided argument value ..: ").append(argValue).append(Constants.NL).append(Constants.NL).append("Root cause:").append(Constants.NL).append(" -> ").append(rootCause).toString();
    }

    static String incompatibleField(Object value, Field field, Throwable cause, Settings settings) {
        OnSetFieldError onSetFieldError = settings.get(Keys.ON_SET_FIELD_ERROR);
        String fieldName = Format.formatField(field);
        String argType = Format.withoutPackage(value.getClass());
        String argValue = StringUtils.quoteToString(value);
        return new StringBuilder(1024).append(Constants.NL).append("Throwing exception because:").append(Constants.NL).append(" -> Keys.ON_SET_FIELD_ERROR = ").append((Object)onSetFieldError).append(Constants.NL).append(Constants.NL).append("Error assigning value to field:").append(Constants.NL).append(Constants.NL).append(" -> Field ....................: ").append(fieldName).append(Constants.NL).append(" -> Provided argument type ...: ").append(argType).append(Constants.NL).append(" -> Provided argument value ..: ").append(argValue).append(Constants.NL).append(Constants.NL).append("Root cause:").append(Constants.NL).append(" -> ").append(AssignerErrorUtil.getRootCause(cause)).append(Constants.NL).append(Constants.NL).append("To ignore the error and leave the field uninitialised").append(Constants.NL).append(" -> Update Keys.ON_SET_FIELD_ERROR setting to: ").append((Object)OnSetFieldError.IGNORE).append(Constants.NL).toString();
    }

    static String setterNotFound(Field field, String expectedMethodName, Settings settings) {
        String fieldName = Format.formatField(field);
        SetterStyle setterStyle = settings.get(Keys.SETTER_STYLE);
        OnSetMethodNotFound onSetMethodNotFound = settings.get(Keys.ON_SET_METHOD_NOT_FOUND);
        return new StringBuilder(1024).append(Constants.NL).append("Throwing exception because:").append(Constants.NL).append(" -> Keys.ASSIGNMENT_TYPE = ").append((Object)AssignmentType.METHOD).append(Constants.NL).append(" -> Keys.ON_SET_METHOD_NOT_FOUND = ").append((Object)onSetMethodNotFound).append(Constants.NL).append(Constants.NL).append("Setter method could not be resolved for field:").append(Constants.NL).append(" -> ").append(fieldName).append(Constants.NL).append(Constants.NL).append("Using:").append(Constants.NL).append(" -> Keys.SETTER_STYLE = ").append((Object)setterStyle).append(Constants.NL).append(" -> Expected method name: '").append(expectedMethodName).append('\'').append(Constants.NL).append(Constants.NL).append("To resolve the error, consider one of the following:").append(Constants.NL).append(" -> Add the expected setter method").append(Constants.NL).append(" -> Update Keys.ON_SET_METHOD_NOT_FOUND setting to:").append(Constants.NL).append("    -> ").append((Object)OnSetMethodNotFound.ASSIGN_FIELD).append(" to assign value via field").append(Constants.NL).append("    -> ").append((Object)OnSetMethodNotFound.IGNORE).append(" to leave value uninitialised").append(Constants.NL).toString();
    }

    static String getSetterInvocationErrorMessage(Object value, String method, Throwable cause, Settings settings) {
        OnSetMethodError onSetMethodError = settings.get(Keys.ON_SET_METHOD_ERROR);
        String argType = Format.withoutPackage(value.getClass());
        String argValue = StringUtils.quoteToString(value);
        return new StringBuilder(1024).append(Constants.NL).append("Throwing exception because:").append(Constants.NL).append(" -> Keys.ASSIGNMENT_TYPE = ").append((Object)AssignmentType.METHOD).append(Constants.NL).append(" -> Keys.ON_SET_METHOD_ERROR = ").append((Object)onSetMethodError).append(Constants.NL).append(Constants.NL).append("Method invocation failed:").append(Constants.NL).append(Constants.NL).append(" -> Method ...................: ").append(method).append(Constants.NL).append(" -> Provided argument type ...: ").append(argType).append(Constants.NL).append(" -> Provided argument value ..: ").append(argValue).append(Constants.NL).append(Constants.NL).append("Root cause:").append(Constants.NL).append(" -> ").append(AssignerErrorUtil.getRootCause(cause)).append(Constants.NL).append(Constants.NL).append("To resolve the error, consider one of the following:").append(Constants.NL).append(" -> Address the root cause that triggered the exception").append(Constants.NL).append(" -> Update Keys.ON_SET_METHOD_ERROR setting to").append(Constants.NL).append("    -> ").append((Object)OnSetMethodError.ASSIGN_FIELD).append(" to assign value via field").append(Constants.NL).append("    -> ").append((Object)OnSetMethodError.IGNORE).append(" to leave value uninitialised").append(Constants.NL).toString();
    }

    private static Throwable getRootCause(Throwable t) {
        Throwable cause = t;
        while (cause.getCause() != null) {
            cause = cause.getCause();
        }
        return cause;
    }
}

