/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.beanvalidation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.BiFunction;
import org.instancio.exception.InstancioException;
import org.instancio.generator.Generator;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.GeneratorSpec;
import org.instancio.internal.beanvalidation.AnnotationHandlerResolver;
import org.instancio.internal.beanvalidation.AnnotationMap;
import org.instancio.internal.beanvalidation.BeanValidationProvider;
import org.instancio.internal.beanvalidation.FieldAnnotationHandler;
import org.instancio.internal.generator.AbstractGenerator;
import org.instancio.internal.generator.lang.StringGenerator;

abstract class AbstractBeanValidationProvider
implements BeanValidationProvider {
    private final Map<Class<? extends Annotation>, BiFunction<Annotation, GeneratorContext, Generator<?>>> map;

    protected AbstractBeanValidationProvider(Map<Class<? extends Annotation>, BiFunction<Annotation, GeneratorContext, Generator<?>>> map) {
        this.map = Collections.unmodifiableMap(map);
    }

    @Override
    public final boolean isPrimary(Class<? extends Annotation> annotationType) {
        return this.map.containsKey(annotationType);
    }

    private Generator<?> resolveGenerator(Annotation annotation, GeneratorContext context) {
        Class<? extends Annotation> annotationType = annotation.annotationType();
        BiFunction<Annotation, GeneratorContext, Generator<?>> generatorBuilder = this.map.get(annotationType);
        if (generatorBuilder != null) {
            return generatorBuilder.apply(annotation, context);
        }
        throw new InstancioException("Unmapped primary annotation:  " + annotationType.getName());
    }

    protected abstract AnnotationHandlerResolver getAnnotationHandlerResolver();

    @Override
    public final void consumeAnnotations(AnnotationMap map, GeneratorSpec<?> spec, Class<?> targetClass, Field field) {
        FieldAnnotationHandler handler;
        AnnotationHandlerResolver resolver = this.getAnnotationHandlerResolver();
        Annotation primary = map.removePrimary();
        if (primary != null) {
            AbstractGenerator suppliedGenerator = (AbstractGenerator)spec;
            GeneratorContext context = suppliedGenerator.getContext();
            Generator<?> actualGenerator = this.resolveGenerator(primary, context);
            ((StringGenerator)spec).setDelegate(actualGenerator);
            handler = resolver.resolveHandler(primary);
            if (handler != null) {
                handler.process(primary, actualGenerator, field, targetClass);
            }
        }
        Collection<Annotation> annotations = map.getAnnotations();
        for (Annotation annotation : annotations) {
            handler = resolver.resolveHandler(annotation);
            if (handler == null) continue;
            handler.process(annotation, spec, field, targetClass);
            map.remove(annotation.annotationType());
        }
    }
}

