/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.time;

import java.time.ZoneOffset;
import org.instancio.Random;
import org.instancio.generator.GeneratorContext;
import org.instancio.internal.generator.AbstractGenerator;

public class ZoneOffsetGenerator
extends AbstractGenerator<ZoneOffset> {
    private static final int MIN_HOURS = -18;
    private static final int MAX_HOURS = 18;

    public ZoneOffsetGenerator(GeneratorContext context) {
        super(context);
    }

    @Override
    public String apiMethod() {
        return null;
    }

    @Override
    protected ZoneOffset tryGenerateNonNull(Random random) {
        int hours = random.intRange(-18, 18);
        if (Math.abs(hours) == 18) {
            return ZoneOffset.ofHoursMinutes(hours, 0);
        }
        int minutes = hours < 0 ? random.intRange(-59, 0) : random.intRange(0, 59);
        return ZoneOffset.ofHoursMinutes(hours, minutes);
    }
}

