/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal;

import org.instancio.generator.AfterGenerate;
import org.instancio.internal.NodePopulationFilter;
import org.instancio.internal.context.ModelContext;
import org.instancio.internal.nodes.Node;
import org.instancio.internal.util.ReflectionUtils;
import org.jetbrains.annotations.Nullable;

class ArrayElementNodePopulationFilter
implements NodePopulationFilter {
    private final ModelContext<?> context;

    ArrayElementNodePopulationFilter(ModelContext<?> context) {
        this.context = context;
    }

    @Override
    public boolean shouldSkip(Node elementNode, AfterGenerate afterGenerate, @Nullable Object currentElementValue) {
        if (afterGenerate == AfterGenerate.DO_NOT_MODIFY) {
            return true;
        }
        if (this.context.getGenerator(elementNode).isPresent()) {
            return false;
        }
        if (afterGenerate == AfterGenerate.POPULATE_NULLS) {
            return elementNode.getRawType().isPrimitive() || currentElementValue != null;
        }
        if (afterGenerate == AfterGenerate.POPULATE_NULLS_AND_DEFAULT_PRIMITIVES) {
            return ReflectionUtils.neitherNullNorPrimitiveWithDefaultValue(elementNode.getRawType(), currentElementValue);
        }
        return afterGenerate != AfterGenerate.POPULATE_ALL;
    }
}

