/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal;

import java.lang.reflect.Modifier;
import org.instancio.Random;
import org.instancio.generator.GeneratorContext;
import org.instancio.internal.GeneratorSpecProcessor;
import org.instancio.internal.beanvalidation.BeanValidationProcessor;
import org.instancio.internal.beanvalidation.NoopBeanValidationProvider;
import org.instancio.internal.context.ModelContext;
import org.instancio.internal.generator.GeneratorResolver;
import org.instancio.internal.generator.GeneratorResult;
import org.instancio.internal.handlers.ArrayNodeHandler;
import org.instancio.internal.handlers.CollectionNodeHandler;
import org.instancio.internal.handlers.InstantiatingHandler;
import org.instancio.internal.handlers.MapNodeHandler;
import org.instancio.internal.handlers.NodeHandler;
import org.instancio.internal.handlers.UserSuppliedGeneratorHandler;
import org.instancio.internal.handlers.UsingGeneratorResolverHandler;
import org.instancio.internal.nodes.Node;
import org.instancio.internal.reflection.instantiation.Instantiator;
import org.instancio.settings.Keys;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GeneratorFacade {
    private static final Logger LOG = LoggerFactory.getLogger(GeneratorFacade.class);
    private final ModelContext<?> context;
    private final Random random;
    private final NodeHandler[] nodeHandlers;

    GeneratorFacade(ModelContext<?> context) {
        this.context = context;
        this.random = context.getRandom();
        GeneratorResolver generatorResolver = new GeneratorResolver(new GeneratorContext(context.getSettings(), this.random));
        Instantiator instantiator = new Instantiator();
        GeneratorSpecProcessor beanValidationProcessor = this.getGeneratorSpecProcessor();
        this.nodeHandlers = new NodeHandler[]{new UserSuppliedGeneratorHandler(context, generatorResolver, instantiator), new ArrayNodeHandler(context, generatorResolver, beanValidationProcessor), new UsingGeneratorResolverHandler(context, generatorResolver, beanValidationProcessor), new CollectionNodeHandler(context, beanValidationProcessor), new MapNodeHandler(context, beanValidationProcessor), new InstantiatingHandler(instantiator)};
    }

    private GeneratorSpecProcessor getGeneratorSpecProcessor() {
        boolean isEnabled = (Boolean)this.context.getSettings().get(Keys.BEAN_VALIDATION_ENABLED);
        LOG.trace("Keys.BEAN_VALIDATION_ENABLED={}", (Object)isEnabled);
        return isEnabled ? new BeanValidationProcessor() : new NoopBeanValidationProvider();
    }

    private boolean isIgnored(Node node) {
        return this.context.isIgnored(node) || node.getField() != null && Modifier.isStatic(node.getField().getModifiers());
    }

    GeneratorResult generateNodeValue(Node node) {
        if (this.isIgnored(node)) {
            return GeneratorResult.ignoredResult();
        }
        if (this.shouldReturnNullForNullable(node)) {
            return GeneratorResult.nullResult();
        }
        GeneratorResult generatorResult = GeneratorResult.emptyResult();
        for (NodeHandler handler : this.nodeHandlers) {
            generatorResult = handler.getResult(node);
            if (generatorResult.isEmpty()) continue;
            LOG.trace("{} generated using '{}'", (Object)node, (Object)handler.getClass().getName());
            break;
        }
        return generatorResult;
    }

    private boolean shouldReturnNullForNullable(Node node) {
        boolean precondition = this.context.isNullable(node);
        return this.random.diceRoll(precondition);
    }
}

