/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.beanvalidation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;
import org.hibernate.validator.constraints.UniqueElements;
import org.instancio.generator.GeneratorSpec;
import org.instancio.generator.specs.CollectionGeneratorSpec;
import org.instancio.generator.specs.NumberGeneratorSpec;
import org.instancio.generator.specs.StringGeneratorSpec;
import org.instancio.internal.beanvalidation.AnnotationHandlerResolver;
import org.instancio.internal.beanvalidation.FieldAnnotationHandler;
import org.instancio.internal.generator.lang.AbstractRandomNumberGeneratorSpec;
import org.instancio.internal.generator.lang.LongGenerator;
import org.instancio.internal.generator.lang.StringGenerator;
import org.instancio.internal.util.BeanValidationUtils;
import org.instancio.internal.util.IntRange;
import org.instancio.internal.util.NumberUtils;
import org.instancio.settings.Keys;

final class HibernateBeanValidationHandlerResolver
implements AnnotationHandlerResolver {
    private final Map<Class<?>, FieldAnnotationHandler> handlerMap = HibernateBeanValidationHandlerResolver.initHandlers();

    private HibernateBeanValidationHandlerResolver() {
    }

    static HibernateBeanValidationHandlerResolver getInstance() {
        return Holder.INSTANCE;
    }

    private static Map<Class<?>, FieldAnnotationHandler> initHandlers() {
        HashMap<Class<UniqueElements>, FieldAnnotationHandler> map = new HashMap<Class<UniqueElements>, FieldAnnotationHandler>();
        map.put(Length.class, new LengthHandler());
        map.put(Range.class, new RangeHandler());
        map.put(UniqueElements.class, new UniqueElementsHandler());
        return Collections.unmodifiableMap(map);
    }

    @Override
    public FieldAnnotationHandler resolveHandler(Annotation annotation) {
        return this.handlerMap.get(annotation.annotationType());
    }

    private static class Holder {
        private static final HibernateBeanValidationHandlerResolver INSTANCE = new HibernateBeanValidationHandlerResolver();

        private Holder() {
        }
    }

    private static class LengthHandler
    implements FieldAnnotationHandler {
        private LengthHandler() {
        }

        @Override
        public void process(Annotation annotation, GeneratorSpec<?> spec, Field field, Class<?> fieldType) {
            Length length = (Length)annotation;
            IntRange range = BeanValidationUtils.calculateRange(length.min(), length.max(), (Integer)Keys.STRING_MAX_LENGTH.defaultValue());
            if (spec instanceof StringGeneratorSpec) {
                StringGeneratorSpec stringSpec = (StringGeneratorSpec)spec;
                stringSpec.length(range.min(), range.max());
                if (range.min() > 0) {
                    stringSpec.allowEmpty(false);
                }
            }
        }
    }

    private static class RangeHandler
    implements FieldAnnotationHandler {
        private RangeHandler() {
        }

        @Override
        public void process(Annotation annotation, GeneratorSpec<?> spec, Field field, Class<?> fieldType) {
            Range range = (Range)annotation;
            if (spec instanceof NumberGeneratorSpec) {
                Function<Long, Long> fromLongConverter = NumberUtils.longConverter(fieldType);
                AbstractRandomNumberGeneratorSpec numSpec = (AbstractRandomNumberGeneratorSpec)spec;
                numSpec.min((Number)fromLongConverter.apply(range.min())).max((Number)fromLongConverter.apply(range.max()));
                BeanValidationUtils.setNonNullablePrimitive(spec, field);
            } else if (spec instanceof StringGenerator) {
                StringGenerator stringGenerator = (StringGenerator)spec;
                LongGenerator numGenerator = new LongGenerator(stringGenerator.getContext()).nullable(false).min(range.min()).max(range.max());
                stringGenerator.setDelegate(numGenerator);
            }
        }
    }

    private static class UniqueElementsHandler
    implements FieldAnnotationHandler {
        private UniqueElementsHandler() {
        }

        @Override
        public void process(Annotation annotation, GeneratorSpec<?> spec, Field field, Class<?> fieldType) {
            if (spec instanceof CollectionGeneratorSpec) {
                ((CollectionGeneratorSpec)spec).unique();
            }
        }
    }
}

