/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.context;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.instancio.GeneratorSpecProvider;
import org.instancio.TargetSelector;
import org.instancio.generator.AfterGenerate;
import org.instancio.generator.Generator;
import org.instancio.generator.GeneratorContext;
import org.instancio.generators.Generators;
import org.instancio.internal.context.SelectorMap;
import org.instancio.internal.generator.InternalGeneratorHint;
import org.instancio.internal.generator.array.ArrayGenerator;
import org.instancio.internal.generator.misc.GeneratorDecorator;
import org.instancio.internal.nodes.Node;
import org.instancio.internal.selectors.Flattener;
import org.instancio.internal.selectors.SelectorImpl;
import org.instancio.internal.util.ReflectionUtils;
import org.instancio.settings.Keys;

class GeneratorSelectorMap {
    private final Map<TargetSelector, Generator<?>> generatorSelectors;
    private final Map<TargetSelector, GeneratorSpecProvider<?>> generatorSpecSelectors;
    private final SelectorMap<Generator<?>> selectorMap = new SelectorMap();
    private final Map<TargetSelector, Class<?>> generatorSubtypeMap = new LinkedHashMap();
    private final AfterGenerate defaultAfterGenerate;
    private final GeneratorContext context;

    GeneratorSelectorMap(GeneratorContext context, Map<TargetSelector, Generator<?>> generatorSelectors, Map<TargetSelector, GeneratorSpecProvider<?>> generatorSpecSelectors) {
        this.context = context;
        this.generatorSelectors = Collections.unmodifiableMap(generatorSelectors);
        this.generatorSpecSelectors = Collections.unmodifiableMap(generatorSpecSelectors);
        this.defaultAfterGenerate = (AfterGenerate)((Object)context.getSettings().get(Keys.AFTER_GENERATE_HINT));
        this.putAllGeneratorSpecs(generatorSpecSelectors);
        this.putAllGenerators(generatorSelectors);
    }

    public SelectorMap<Generator<?>> getSelectorMap() {
        return this.selectorMap;
    }

    Map<TargetSelector, Generator<?>> getGeneratorSelectors() {
        return this.generatorSelectors;
    }

    Map<TargetSelector, GeneratorSpecProvider<?>> getGeneratorSpecSelectors() {
        return this.generatorSpecSelectors;
    }

    public Map<TargetSelector, Class<?>> getGeneratorSubtypeMap() {
        return Collections.unmodifiableMap(this.generatorSubtypeMap);
    }

    Optional<Generator<?>> getGenerator(Node node) {
        return this.selectorMap.getValue(node);
    }

    private void putAllGenerators(Map<TargetSelector, Generator<?>> generatorSelectors) {
        for (Map.Entry<TargetSelector, Generator<?>> entry : generatorSelectors.entrySet()) {
            TargetSelector targetSelector = entry.getKey();
            Generator<?> generator = entry.getValue();
            for (TargetSelector selector : ((Flattener)((Object)targetSelector)).flatten()) {
                this.putGenerator(selector, generator);
            }
        }
    }

    private void putAllGeneratorSpecs(Map<TargetSelector, GeneratorSpecProvider<?>> specs) {
        Generators generators = new Generators(this.context);
        for (Map.Entry<TargetSelector, GeneratorSpecProvider<?>> entry : specs.entrySet()) {
            TargetSelector targetSelector = entry.getKey();
            GeneratorSpecProvider<?> genFn = entry.getValue();
            for (TargetSelector selector : ((Flattener)((Object)targetSelector)).flatten()) {
                Generator generator = (Generator)genFn.getSpec(generators);
                this.putGenerator(selector, generator);
            }
        }
    }

    private void putGenerator(TargetSelector targetSelector, Generator<?> g) {
        Generator<?> generator = GeneratorDecorator.decorate(g, this.defaultAfterGenerate);
        this.selectorMap.put(targetSelector, generator);
        InternalGeneratorHint internalHint = generator.hints().get(InternalGeneratorHint.class);
        Optional<Class> generatorTargetClass = Optional.ofNullable(internalHint).map(InternalGeneratorHint::targetClass);
        generatorTargetClass.ifPresent(aClass -> this.generatorSubtypeMap.put(targetSelector, (Class<?>)aClass));
        if (targetSelector instanceof SelectorImpl) {
            SelectorImpl selector = (SelectorImpl)targetSelector;
            if (selector.isFieldSelector()) {
                Field field = ReflectionUtils.getField(selector.getTargetClass(), selector.getFieldName());
                Class<?> userSpecifiedClass = generatorTargetClass.orElse(field.getType());
                if (generator instanceof ArrayGenerator) {
                    ((ArrayGenerator)generator).subtype((Class)userSpecifiedClass);
                }
            } else {
                Class<?> userSpecifiedClass = generatorTargetClass.orElse(selector.getTargetClass());
                if (generator instanceof ArrayGenerator) {
                    ((ArrayGenerator)generator).subtype((Class)userSpecifiedClass);
                }
            }
        }
    }
}

