/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.context;

import java.util.Set;
import java.util.stream.Collectors;
import org.instancio.TargetSelector;
import org.instancio.exception.UnusedSelectorException;
import org.instancio.internal.selectors.UnusedSelectorDescription;
import org.instancio.internal.util.Constants;

final class UnusedSelectorReporter {
    private final Set<? super TargetSelector> ignored;
    private final Set<? super TargetSelector> nullable;
    private final Set<? super TargetSelector> generators;
    private final Set<? super TargetSelector> callbacks;
    private final Set<? super TargetSelector> subtypes;

    private UnusedSelectorReporter(Builder builder) {
        this.ignored = builder.ignored;
        this.nullable = builder.nullable;
        this.generators = builder.generators;
        this.callbacks = builder.callbacks;
        this.subtypes = builder.subtypes;
    }

    public static Builder builder() {
        return new Builder();
    }

    void report() {
        if (this.hasNoUnusedSelectors()) {
            return;
        }
        StringBuilder sb = new StringBuilder(2048).append(Constants.NL).append("Found unused selectors referenced in the following methods:").append(Constants.NL);
        UnusedSelectorReporter.append(this.ignored, sb, "ignore()");
        UnusedSelectorReporter.append(this.nullable, sb, "withNullable()");
        UnusedSelectorReporter.append(this.generators, sb, "generate(), set(), or supply()");
        UnusedSelectorReporter.append(this.callbacks, sb, "onComplete()");
        UnusedSelectorReporter.append(this.subtypes, sb, "subtype()");
        sb.append(Constants.NL).append("This error aims to highlight potential problems and help maintain clean test code.").append(Constants.NL).append(Constants.NL).append("Possible causes:").append(Constants.NL).append(Constants.NL).append(" -> Selector did not match any field or class within this object.").append(Constants.NL).append(" -> Selector matches an ignored target, for example:").append(Constants.NL).append(Constants.NL).append("    Person person = Instancio.of(Person.class)").append(Constants.NL).append("        .ignore(all(Phone.class))").append(Constants.NL).append("        .set(field(Phone::getNumber), \"555-66-77\") // unused!").append(Constants.NL).append("        .create();").append(Constants.NL).append(Constants.NL).append(" -> Selector targets a field or class in an object that was provided by:").append(Constants.NL).append("    -> set(TargetSelector, Object)").append(Constants.NL).append("    -> supply(TargetSelector, Supplier)").append(Constants.NL).append(Constants.NL).append("    // Example").append(Constants.NL).append("    Supplier<Address> addressSupplier = () -> new Address(...);").append(Constants.NL).append("    Person person = Instancio.of(Person.class)").append(Constants.NL).append("        .supply(all(Address.class), () -> addressSupplier)").append(Constants.NL).append("        .set(field(Address::getCity), \"London\") // unused!").append(Constants.NL).append("        .create();").append(Constants.NL).append(Constants.NL).append("    Instancio does not modify instances provided by a Supplier,").append(Constants.NL).append("    therefore, field(Address::getCity) will trigger unused selector error.").append(Constants.NL).append(Constants.NL).append("To resolve this error:").append(Constants.NL).append(Constants.NL).append(" -> Remove the selector(s) causing the error, if applicable.").append(Constants.NL).append(" -> Suppress the error by enabling 'lenient()' mode:").append(Constants.NL).append(Constants.NL).append("    Example example = Instancio.of(Example.class)").append(Constants.NL).append("        .lenient()").append(Constants.NL).append("        .create();").append(Constants.NL).append(Constants.NL).append("    // Or via Settings").append(Constants.NL).append("    Settings settings = Settings.create()").append(Constants.NL).append("        .set(Keys.MODE, Mode.LENIENT);").append(Constants.NL).append(Constants.NL).append("    Example example = Instancio.of(Example.class)").append(Constants.NL).append("        .withSettings(settings)").append(Constants.NL).append("        .create();").append(Constants.NL).append(Constants.NL).append("For more information see: https://www.instancio.org/user-guide/#selector-strictness");
        throw new UnusedSelectorException(sb.toString(), this.ignored, this.nullable, this.generators, this.callbacks, this.subtypes);
    }

    private static void append(Set<? super TargetSelector> selectors, StringBuilder sb, String apiMethodName) {
        if (!selectors.isEmpty()) {
            sb.append(Constants.NL).append(" -> Unused selectors in ").append(apiMethodName).append(':').append(Constants.NL).append(UnusedSelectorReporter.formatSelectors(selectors)).append(Constants.NL);
        }
    }

    private boolean hasNoUnusedSelectors() {
        return this.ignored.isEmpty() && this.nullable.isEmpty() && this.generators.isEmpty() && this.callbacks.isEmpty() && this.subtypes.isEmpty();
    }

    private static String formatSelectors(Set<? super TargetSelector> selectors) {
        int[] count = new int[]{1};
        return selectors.stream().map(UnusedSelectorDescription.class::cast).map(UnusedSelectorDescription::getDescription).distinct().sorted().map(it -> {
            Object[] objectArray = new Object[2];
            int n = count[0];
            count[0] = n + 1;
            objectArray[0] = n;
            objectArray[1] = it;
            return String.format(" %s: %s", objectArray);
        }).collect(Collectors.joining(Constants.NL));
    }

    public static final class Builder {
        private Set<? super TargetSelector> ignored;
        private Set<? super TargetSelector> nullable;
        private Set<? super TargetSelector> generators;
        private Set<? super TargetSelector> callbacks;
        private Set<? super TargetSelector> subtypes;

        private Builder() {
        }

        public Builder ignored(Set<? super TargetSelector> ignored) {
            this.ignored = ignored;
            return this;
        }

        public Builder nullable(Set<? super TargetSelector> nullable) {
            this.nullable = nullable;
            return this;
        }

        public Builder generators(Set<? super TargetSelector> generators) {
            this.generators = generators;
            return this;
        }

        public Builder callbacks(Set<? super TargetSelector> callbacks) {
            this.callbacks = callbacks;
            return this;
        }

        public Builder subtypes(Set<? super TargetSelector> subtypes) {
            this.subtypes = subtypes;
            return this;
        }

        public UnusedSelectorReporter build() {
            return new UnusedSelectorReporter(this);
        }
    }
}

