/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator;

import java.util.StringJoiner;
import org.instancio.documentation.InternalApi;
import org.instancio.generator.Hint;

@InternalApi
public final class InternalGeneratorHint
implements Hint<InternalGeneratorHint> {
    private final Class<?> targetClass;
    private final boolean isDelegating;
    private final boolean excludeFromCallbacks;
    private final boolean nullableResult;

    private InternalGeneratorHint(Builder builder) {
        this.targetClass = builder.targetClass;
        this.isDelegating = builder.isDelegating;
        this.excludeFromCallbacks = builder.excludeFromCallbacks;
        this.nullableResult = builder.nullableResult;
    }

    public Class<?> targetClass() {
        return this.targetClass;
    }

    public boolean isDelegating() {
        return this.isDelegating;
    }

    public boolean excludeFromCallbacks() {
        return this.excludeFromCallbacks;
    }

    public boolean nullableResult() {
        return this.nullableResult;
    }

    public String toString() {
        return new StringJoiner(", ", "GeneratorHint[", "]").add("targetClass=" + (this.targetClass == null ? null : this.targetClass.getTypeName())).add("isDelegating=" + this.isDelegating).add("nullableResult=" + this.nullableResult).add("excludeFromCallbacks=" + this.excludeFromCallbacks).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Class<?> targetClass;
        private boolean isDelegating;
        private boolean excludeFromCallbacks;
        private boolean nullableResult;

        private Builder() {
        }

        public static Builder builder() {
            return new Builder();
        }

        public Builder targetClass(Class<?> targetClass) {
            this.targetClass = targetClass;
            return this;
        }

        public Builder delegating(boolean isDelegating) {
            this.isDelegating = isDelegating;
            return this;
        }

        public Builder excludeFromCallbacks(boolean excludeFromCallbacks) {
            this.excludeFromCallbacks = excludeFromCallbacks;
            return this;
        }

        public Builder nullableResult(boolean nullableResult) {
            this.nullableResult = nullableResult;
            return this;
        }

        public InternalGeneratorHint build() {
            return new InternalGeneratorHint(this);
        }
    }
}

