/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.domain.finance;

import org.instancio.Random;
import org.instancio.generator.GeneratorContext;
import org.instancio.internal.generator.AbstractGenerator;
import org.instancio.internal.generator.domain.finance.CreditCardType;
import org.instancio.internal.util.LuhnUtils;

public class CreditCardNumberGenerator
extends AbstractGenerator<String> {
    private CreditCardType cardType = CreditCardType.VISA16;

    public CreditCardNumberGenerator(GeneratorContext context) {
        super(context);
    }

    @Override
    public String apiMethod() {
        return null;
    }

    public CreditCardNumberGenerator cardType(CreditCardType cardType) {
        this.cardType = cardType;
        return this;
    }

    public CreditCardNumberGenerator nullable() {
        super.nullable();
        return this;
    }

    @Override
    public String generate(Random random) {
        if (random.diceRoll(this.isNullable())) {
            return null;
        }
        String prefix = random.oneOf(this.cardType.getPrefixes()).toString();
        int lengthWithoutCheckDigit = this.cardType.getLength() - prefix.length();
        String withoutCheckDigit = prefix + random.digits(lengthWithoutCheckDigit);
        char[] payload = withoutCheckDigit.toCharArray();
        int checkDigit = LuhnUtils.getCheckDigit(payload);
        payload[payload.length - 1] = (char)(checkDigit + 48);
        return new String(payload);
    }
}

