/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.lang;

import org.instancio.Random;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.NumberAsStringGeneratorSpec;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.generator.AbstractGenerator;

public abstract class AbstractRandomNumberGeneratorSpec<T extends Number>
extends AbstractGenerator<T>
implements NumberAsStringGeneratorSpec<T> {
    private T min;
    private T max;

    protected AbstractRandomNumberGeneratorSpec(GeneratorContext context, T min, T max, boolean nullable) {
        super(context);
        super.nullable(nullable);
        this.min = min;
        this.max = max;
    }

    protected abstract T generateNonNullValue(Random var1);

    protected T getMin() {
        return this.min;
    }

    protected T getMax() {
        return this.max;
    }

    @Override
    public NumberAsStringGeneratorSpec<T> min(T min) {
        this.min = (Number)ApiValidator.notNull(min, "'min' must not be null", new Object[0]);
        return this;
    }

    @Override
    public NumberAsStringGeneratorSpec<T> max(T max) {
        this.max = (Number)ApiValidator.notNull(max, "'max' must not be null", new Object[0]);
        return this;
    }

    @Override
    public NumberAsStringGeneratorSpec<T> nullable() {
        super.nullable();
        return this;
    }

    @Override
    public NumberAsStringGeneratorSpec<T> nullable(boolean isNullable) {
        super.nullable(isNullable);
        return this;
    }

    @Override
    public NumberAsStringGeneratorSpec<T> range(T min, T max) {
        this.min = (Number)ApiValidator.notNull(min, "'min' must not be null", new Object[0]);
        this.max = (Number)ApiValidator.notNull(max, "'max' must not be null", new Object[0]);
        return this;
    }

    @Override
    public final T generate(Random random) {
        return random.diceRoll(this.isNullable()) ? null : (T)this.generateNonNullValue(random);
    }
}

