/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.lang;

import org.instancio.Random;
import org.instancio.generator.GeneratorContext;
import org.instancio.internal.generator.AbstractGenerator;
import org.instancio.settings.Keys;
import org.instancio.settings.Settings;

public class StringBuilderGenerator
extends AbstractGenerator<StringBuilder> {
    private final int minLength;
    private final int maxLength;

    public StringBuilderGenerator(GeneratorContext context) {
        super(context);
        Settings settings = context.getSettings();
        this.minLength = (Integer)settings.get(Keys.STRING_MIN_LENGTH);
        this.maxLength = (Integer)settings.get(Keys.STRING_MAX_LENGTH);
    }

    @Override
    public String apiMethod() {
        return null;
    }

    @Override
    public StringBuilder generate(Random random) {
        int length = random.intRange(this.minLength, this.maxLength + 1);
        return new StringBuilder(random.upperCaseAlphabetic(length));
    }
}

