/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.math;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.instancio.Random;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.BigDecimalAsStringGeneratorSpec;
import org.instancio.generator.specs.BigDecimalSpec;
import org.instancio.internal.context.Global;
import org.instancio.internal.generator.lang.AbstractRandomComparableNumberGeneratorSpec;

public class BigDecimalGenerator
extends AbstractRandomComparableNumberGeneratorSpec<BigDecimal>
implements BigDecimalSpec,
BigDecimalAsStringGeneratorSpec {
    private static final BigDecimal DEFAULT_MIN = BigDecimal.valueOf(1.0E-5);
    private static final BigDecimal DEFAULT_MAX = BigDecimal.valueOf(10000L);
    private static final int DEFAULT_SCALE = 5;
    private int scale = 5;

    public BigDecimalGenerator() {
        this(Global.generatorContext());
    }

    public BigDecimalGenerator(GeneratorContext context) {
        this(context, DEFAULT_MIN, DEFAULT_MAX, false);
    }

    public BigDecimalGenerator(GeneratorContext context, BigDecimal min, BigDecimal max, boolean nullable) {
        super(context, min, max, nullable);
    }

    @Override
    public String apiMethod() {
        return "bigDecimal()";
    }

    @Override
    public BigDecimalGenerator scale(int scale) {
        this.scale = scale;
        return this;
    }

    @Override
    public BigDecimalGenerator min(BigDecimal min) {
        super.min(min);
        return this;
    }

    @Override
    public BigDecimalGenerator max(BigDecimal max) {
        super.max(max);
        return this;
    }

    @Override
    public BigDecimalGenerator range(BigDecimal min, BigDecimal max) {
        super.range(min, max);
        return this;
    }

    @Override
    public BigDecimalGenerator nullable() {
        super.nullable();
        return this;
    }

    @Override
    public BigDecimalGenerator nullable(boolean isNullable) {
        super.nullable(isNullable);
        return this;
    }

    @Override
    protected BigDecimal generateNonNullValue(Random random) {
        BigDecimal delta = ((BigDecimal)this.getMax()).subtract((BigDecimal)this.getMin());
        BigDecimal rndDelta = delta.multiply(BigDecimal.valueOf(random.doubleRange(0.01, 1.0)));
        return ((BigDecimal)this.getMin()).add(rndDelta).setScale(this.scale, RoundingMode.HALF_UP);
    }
}

