/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.math;

import java.math.BigInteger;
import org.instancio.Random;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.BigIntegerSpec;
import org.instancio.internal.context.Global;
import org.instancio.internal.generator.lang.AbstractRandomComparableNumberGeneratorSpec;

public class BigIntegerGenerator
extends AbstractRandomComparableNumberGeneratorSpec<BigInteger>
implements BigIntegerSpec {
    private static final BigInteger DEFAULT_MIN = BigInteger.ONE;
    private static final BigInteger DEFAULT_MAX = BigInteger.valueOf(Long.MAX_VALUE);

    public BigIntegerGenerator() {
        this(Global.generatorContext());
    }

    public BigIntegerGenerator(GeneratorContext context) {
        super(context, DEFAULT_MIN, DEFAULT_MAX, false);
    }

    public BigIntegerGenerator(GeneratorContext context, BigInteger min, BigInteger max, boolean nullable) {
        super(context, min, max, nullable);
    }

    @Override
    public String apiMethod() {
        return "bigInteger()";
    }

    @Override
    public BigIntegerGenerator min(BigInteger min) {
        super.min(min);
        return this;
    }

    @Override
    public BigIntegerGenerator max(BigInteger max) {
        super.max(max);
        return this;
    }

    @Override
    public BigIntegerGenerator range(BigInteger min, BigInteger max) {
        super.range(min, max);
        return this;
    }

    @Override
    public BigIntegerGenerator nullable() {
        super.nullable();
        return this;
    }

    @Override
    public BigIntegerGenerator nullable(boolean isNullable) {
        super.nullable(isNullable);
        return this;
    }

    @Override
    protected BigInteger generateNonNullValue(Random random) {
        BigInteger delta = ((BigInteger)this.getMax()).subtract((BigInteger)this.getMin());
        BigInteger rndDelta = delta.multiply(BigInteger.valueOf(random.intRange(1, 100))).divide(BigInteger.valueOf(100L));
        return ((BigInteger)this.getMin()).add(rndDelta);
    }
}

