/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.sql;

import java.sql.Date;
import org.instancio.Random;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.TemporalGeneratorSpec;
import org.instancio.internal.generator.AbstractGenerator;
import org.instancio.internal.generator.time.LocalDateGenerator;

public class SqlDateGenerator
extends AbstractGenerator<Date>
implements TemporalGeneratorSpec<Date> {
    private final LocalDateGenerator delegate;

    public SqlDateGenerator(GeneratorContext context) {
        super(context);
        this.delegate = new LocalDateGenerator(context);
    }

    @Override
    public String apiMethod() {
        return "sqlDate()";
    }

    public SqlDateGenerator past() {
        this.delegate.past();
        return this;
    }

    public SqlDateGenerator future() {
        this.delegate.future();
        return this;
    }

    public SqlDateGenerator range(Date start, Date end) {
        this.delegate.range(start.toLocalDate(), end.toLocalDate());
        return this;
    }

    public SqlDateGenerator nullable() {
        super.nullable();
        return this;
    }

    @Override
    public Date generate(Random random) {
        return random.diceRoll(this.isNullable()) ? null : Date.valueOf(this.delegate.generateNonNullValue(random));
    }
}

