/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.time;

import java.time.temporal.Temporal;
import org.instancio.Random;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.TemporalAaStringGeneratorSpec;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.generator.AbstractGenerator;

abstract class JavaTimeTemporalGenerator<T extends Temporal>
extends AbstractGenerator<T>
implements TemporalAaStringGeneratorSpec<T> {
    private final T defaultMin;
    private final T defaultMax;
    protected T min;
    protected T max;

    JavaTimeTemporalGenerator(GeneratorContext context, T min, T max) {
        super(context);
        this.defaultMin = min;
        this.defaultMax = max;
        this.min = min;
        this.max = max;
    }

    protected abstract T generateNonNullValue(Random var1);

    abstract T getLatestPast();

    abstract T getEarliestFuture();

    abstract void validateRange();

    @Override
    public TemporalAaStringGeneratorSpec<T> past() {
        this.min = this.defaultMin;
        this.max = this.getLatestPast();
        return this;
    }

    @Override
    public TemporalAaStringGeneratorSpec<T> future() {
        this.min = this.getEarliestFuture();
        this.max = this.defaultMax;
        return this;
    }

    @Override
    public TemporalAaStringGeneratorSpec<T> range(T start, T end) {
        this.min = (Temporal)ApiValidator.notNull(start, "Start parameter must not be null", new Object[0]);
        this.max = (Temporal)ApiValidator.notNull(end, "End parameter must not be null", new Object[0]);
        this.validateRange();
        return this;
    }

    @Override
    public final T generate(Random random) {
        return random.diceRoll(this.isNullable()) ? null : (T)this.generateNonNullValue(random);
    }
}

