/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.time;

import java.time.LocalTime;
import org.instancio.Random;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.LocalTimeSpec;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.context.Global;
import org.instancio.internal.generator.time.JavaTimeTemporalGenerator;
import org.jetbrains.annotations.VisibleForTesting;

public class LocalTimeGenerator
extends JavaTimeTemporalGenerator<LocalTime>
implements LocalTimeSpec {
    private static final int CUT_OFF_BUFFER_MINUTES = 1;

    public LocalTimeGenerator() {
        this(Global.generatorContext());
    }

    public LocalTimeGenerator(GeneratorContext context) {
        super(context, LocalTime.MIN, LocalTime.MAX);
    }

    @Override
    public String apiMethod() {
        return "localTime()";
    }

    @Override
    public LocalTimeGenerator past() {
        super.past();
        return this;
    }

    @Override
    public LocalTimeGenerator future() {
        super.future();
        return this;
    }

    @Override
    public LocalTimeGenerator range(LocalTime start, LocalTime end) {
        super.range(start, end);
        return this;
    }

    @Override
    public LocalTimeGenerator nullable() {
        super.nullable();
        return this;
    }

    @Override
    LocalTime getLatestPast() {
        LocalTime now = this.getNow();
        LocalTime latestPast = now.minusMinutes(1L);
        return latestPast.isAfter(now) ? LocalTime.MIN : latestPast;
    }

    @Override
    LocalTime getEarliestFuture() {
        LocalTime now = this.getNow();
        LocalTime earliestFuture = now.plusMinutes(1L);
        return earliestFuture.isBefore(now) ? LocalTime.MAX : earliestFuture;
    }

    @VisibleForTesting
    LocalTime getNow() {
        return LocalTime.now();
    }

    @Override
    void validateRange() {
        ApiValidator.isTrue(((LocalTime)this.min).compareTo((LocalTime)this.max) <= 0, "Start must not exceed end: %s, %s", this.min, this.max);
    }

    @Override
    public LocalTime generateNonNullValue(Random random) {
        return LocalTime.ofNanoOfDay(random.longRange(((LocalTime)this.min).toNanoOfDay(), ((LocalTime)this.max).toNanoOfDay()));
    }
}

