/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.time;

import java.time.OffsetTime;
import java.time.ZoneOffset;
import org.instancio.Random;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.OffsetTimeSpec;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.context.Global;
import org.instancio.internal.generator.time.JavaTimeTemporalGenerator;
import org.instancio.internal.util.Constants;
import org.jetbrains.annotations.VisibleForTesting;

public class OffsetTimeGenerator
extends JavaTimeTemporalGenerator<OffsetTime>
implements OffsetTimeSpec {
    private static final int CUT_OFF_BUFFER_MINUTES = 1;
    private static final ZoneOffset ZONE_OFFSET = Constants.ZONE_OFFSET;

    public OffsetTimeGenerator() {
        this(Global.generatorContext());
    }

    public OffsetTimeGenerator(GeneratorContext context) {
        super(context, OffsetTime.MIN, OffsetTime.MAX);
    }

    @Override
    public String apiMethod() {
        return "offsetTime()";
    }

    @Override
    public OffsetTimeGenerator past() {
        super.past();
        return this;
    }

    @Override
    public OffsetTimeGenerator future() {
        super.future();
        return this;
    }

    @Override
    public OffsetTimeGenerator range(OffsetTime start, OffsetTime end) {
        super.range(start, end);
        return this;
    }

    @Override
    public OffsetTimeGenerator nullable() {
        super.nullable();
        return this;
    }

    @Override
    OffsetTime getLatestPast() {
        OffsetTime now = this.getNow();
        OffsetTime latestPast = now.minusMinutes(1L);
        return latestPast.isAfter(now) ? OffsetTime.MIN : latestPast;
    }

    @Override
    OffsetTime getEarliestFuture() {
        OffsetTime now = this.getNow();
        OffsetTime earliestFuture = now.plusMinutes(1L);
        return earliestFuture.isBefore(now) ? OffsetTime.MAX : earliestFuture;
    }

    @VisibleForTesting
    OffsetTime getNow() {
        return OffsetTime.now(ZoneOffset.UTC);
    }

    @Override
    void validateRange() {
        ApiValidator.isTrue(((OffsetTime)this.min).compareTo((OffsetTime)this.max) <= 0, "Start must not exceed end: %s, %s", this.min, this.max);
    }

    @Override
    public OffsetTime generateNonNullValue(Random random) {
        int hour = random.intRange(((OffsetTime)this.min).getHour(), ((OffsetTime)this.max).getHour());
        int minute = random.intRange(((OffsetTime)this.min).getMinute(), ((OffsetTime)this.max).getMinute());
        int second = random.intRange(((OffsetTime)this.min).getSecond(), ((OffsetTime)this.max).getSecond());
        int nano = random.intRange(((OffsetTime)this.min).getNano(), ((OffsetTime)this.max).getNano());
        return OffsetTime.of(hour, minute, second, nano, ZONE_OFFSET);
    }
}

