/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.util;

import java.util.Arrays;
import java.util.EnumSet;
import org.instancio.Random;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.Hints;
import org.instancio.generator.specs.EnumSetGeneratorSpec;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.generator.AbstractGenerator;
import org.instancio.internal.generator.InternalContainerHint;
import org.instancio.internal.util.CollectionUtils;
import org.instancio.internal.util.NumberUtils;
import org.instancio.internal.util.ObjectUtils;

public class EnumSetGenerator<E extends Enum<E>>
extends AbstractGenerator<EnumSet<E>>
implements EnumSetGeneratorSpec<E> {
    private final Class<E> enumClass;
    private final int generateEntriesHint;
    private Integer minSize = 1;
    private Integer maxSize;
    private EnumSet<E> including;
    private EnumSet<E> excluding;

    public EnumSetGenerator(GeneratorContext context, Class<E> enumClass) {
        super(context);
        this.enumClass = ApiValidator.notNull(enumClass, "Enum class must not be null", new Object[0]);
        this.generateEntriesHint = 0;
    }

    @Override
    public String apiMethod() {
        return "enumSet()";
    }

    public EnumSetGenerator(GeneratorContext context) {
        super(context);
        this.enumClass = null;
        this.generateEntriesHint = 1;
    }

    @Override
    public EnumSetGeneratorSpec<E> size(int size) {
        this.minSize = ApiValidator.validateSize(size);
        this.maxSize = size;
        return this;
    }

    @Override
    public EnumSetGeneratorSpec<E> minSize(int size) {
        this.minSize = ApiValidator.validateSize(size);
        this.maxSize = NumberUtils.calculateNewMaxSize(this.maxSize, this.minSize);
        return this;
    }

    @Override
    public EnumSetGeneratorSpec<E> maxSize(int size) {
        this.maxSize = ApiValidator.validateSize(size);
        this.minSize = NumberUtils.calculateNewMinSize(this.minSize, this.maxSize);
        return this;
    }

    @Override
    @SafeVarargs
    public final EnumSetGeneratorSpec<E> of(E ... elements) {
        this.including = EnumSet.copyOf(Arrays.asList(elements));
        return this;
    }

    @Override
    @SafeVarargs
    public final EnumSetGeneratorSpec<E> excluding(E ... elements) {
        this.excluding = EnumSet.copyOf(Arrays.asList(elements));
        return this;
    }

    @Override
    public EnumSet<E> generate(Random random) {
        if (this.enumClass != null) {
            return this.createEnumSet(this.enumClass, random);
        }
        return null;
    }

    private EnumSet<E> createEnumSet(Class<E> targetClass, Random random) {
        if (CollectionUtils.isNullOrEmpty(this.including) && CollectionUtils.isNullOrEmpty(this.excluding)) {
            EnumSet<E> choices = EnumSet.allOf(this.enumClass);
            int min = ObjectUtils.defaultIfNull(this.minSize, 1);
            int max = ObjectUtils.defaultIfNull(this.maxSize, choices.size());
            int size = random.intRange(min, max);
            EnumSet<Enum> result = EnumSet.noneOf(targetClass);
            while (result.size() < size && !choices.isEmpty()) {
                Enum next = (Enum)random.oneOf(choices);
                result.add(next);
                choices.remove(next);
            }
            return result;
        }
        if (!CollectionUtils.isNullOrEmpty(this.including)) {
            int min = ObjectUtils.defaultIfNull(this.minSize, 1);
            int max = ObjectUtils.defaultIfNull(this.maxSize, this.including.size());
            int size = random.intRange(min, max);
            EnumSet<Enum> result = EnumSet.noneOf(targetClass);
            EnumSet<E> choices = EnumSet.copyOf(this.including);
            while (result.size() < size && !choices.isEmpty()) {
                Enum next = (Enum)random.oneOf(choices);
                result.add(next);
                choices.remove(next);
            }
            return result;
        }
        EnumSet<E> result = EnumSet.allOf(targetClass);
        if (this.excluding != null) {
            this.excluding.forEach(result::remove);
        }
        while (this.maxSize != null && result.size() > this.maxSize) {
            result.remove(result.iterator().next());
        }
        return result;
    }

    @Override
    public Hints hints() {
        return Hints.builder().with(InternalContainerHint.builder().generateEntries(this.generateEntriesHint).createFunction(args -> EnumSet.noneOf(args[0].getClass())).addFunction((enumSet, args) -> enumSet.add((Enum)args[0])).build()).build();
    }
}

