/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.util.concurrent.atomic;

import java.util.concurrent.atomic.AtomicLong;
import org.instancio.Random;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.NumberGeneratorSpec;
import org.instancio.internal.generator.lang.AbstractRandomNumberGeneratorSpec;

public class AtomicLongGenerator
extends AbstractRandomNumberGeneratorSpec<AtomicLong>
implements NumberGeneratorSpec<AtomicLong> {
    private static final int DEFAULT_MIN = 1;
    private static final int DEFAULT_MAX = 10000;

    public AtomicLongGenerator(GeneratorContext context) {
        super(context, new AtomicLong(1L), new AtomicLong(10000L), false);
    }

    @Override
    public String apiMethod() {
        return "atomicLong()";
    }

    @Override
    protected AtomicLong generateNonNullValue(Random random) {
        return new AtomicLong(random.intRange(((AtomicLong)this.getMin()).intValue(), ((AtomicLong)this.getMax()).intValue()));
    }
}

