/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.handlers;

import java.util.Optional;
import org.instancio.generator.Generator;
import org.instancio.generator.Hints;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.context.ModelContext;
import org.instancio.internal.generator.AbstractGenerator;
import org.instancio.internal.generator.GeneratorResolver;
import org.instancio.internal.generator.GeneratorResult;
import org.instancio.internal.generator.InternalGeneratorHint;
import org.instancio.internal.generator.misc.GeneratorDecorator;
import org.instancio.internal.generator.misc.InstantiatingGenerator;
import org.instancio.internal.handlers.NodeHandler;
import org.instancio.internal.nodes.Node;
import org.instancio.internal.reflection.instantiation.Instantiator;
import org.instancio.internal.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;

public class UserSuppliedGeneratorHandler
implements NodeHandler {
    private final ModelContext<?> modelContext;
    private final GeneratorResolver generatorResolver;
    private final Instantiator instantiator;

    public UserSuppliedGeneratorHandler(ModelContext<?> modelContext, GeneratorResolver generatorResolver, Instantiator instantiator) {
        this.modelContext = modelContext;
        this.generatorResolver = generatorResolver;
        this.instantiator = instantiator;
    }

    @Override
    @NotNull
    public GeneratorResult getResult(@NotNull Node node) {
        return this.getUserSuppliedGenerator(node).map(generator -> {
            boolean nullable;
            Hints hints = generator.hints();
            InternalGeneratorHint internalHint = hints.get(InternalGeneratorHint.class);
            boolean bl = nullable = internalHint != null && internalHint.nullableResult();
            if (this.modelContext.getRandom().diceRoll(nullable)) {
                return GeneratorResult.nullResult();
            }
            Object value = generator.generate(this.modelContext.getRandom());
            return GeneratorResult.create(value, hints);
        }).orElse(GeneratorResult.emptyResult());
    }

    private Optional<Generator<?>> getUserSuppliedGenerator(Node node) {
        Optional<Generator<?>> generatorOpt = this.modelContext.getGenerator(node);
        if (generatorOpt.isPresent()) {
            Generator<?> generator = generatorOpt.get();
            ApiValidator.validateGeneratorUsage(node, generator);
            Hints hints = generator.hints();
            InternalGeneratorHint internalHint = hints.get(InternalGeneratorHint.class);
            if (internalHint != null && internalHint.isDelegating()) {
                Class<?> forClass = ObjectUtils.defaultIfNull(internalHint.targetClass(), node.getTargetClass());
                Generator delegate = this.generatorResolver.get(forClass).orElse(new InstantiatingGenerator(this.instantiator, forClass));
                if (delegate instanceof AbstractGenerator) {
                    boolean nullable = ((AbstractGenerator)generator).isNullable();
                    ((AbstractGenerator)delegate).nullable(nullable);
                }
                return Optional.of(new GeneratorDecorator(delegate, hints));
            }
        }
        return generatorOpt;
    }
}

