/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.nodes;

import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.instancio.exception.InstancioException;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.nodes.Node;
import org.instancio.internal.nodes.NodeContext;
import org.instancio.internal.nodes.NodeKind;
import org.instancio.internal.nodes.NodeKindResolver;
import org.instancio.internal.reflection.DeclaredAndInheritedFieldsCollector;
import org.instancio.internal.reflection.FieldCollector;
import org.instancio.internal.util.Format;
import org.instancio.internal.util.ObjectUtils;
import org.instancio.internal.util.TypeUtils;
import org.instancio.internal.util.Verify;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NodeFactory {
    private static final Logger LOG = LoggerFactory.getLogger(NodeFactory.class);
    private final FieldCollector fieldCollector = new DeclaredAndInheritedFieldsCollector();
    private final NodeContext nodeContext;

    public NodeFactory(NodeContext nodeContext) {
        this.nodeContext = nodeContext;
    }

    public Node createRootNode(Type type) {
        return this.createNode(type, null, null);
    }

    private Node createNode(Type type, @Nullable Field field, @Nullable Node parent) {
        Node node;
        Verify.notNull(type, "'type' is null", new Object[0]);
        if (parent != null && parent.getDepth() >= this.nodeContext.getMaxDepth()) {
            LOG.trace("Maximum depth ({}) reached {}", (Object)this.nodeContext.getMaxDepth(), (Object)parent);
            return null;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Creating node for: {}", (Object)Format.withoutPackage(type));
        }
        if (type instanceof Class) {
            node = this.fromClass((Class)type, field, parent);
        } else if (type instanceof ParameterizedType) {
            node = this.fromParameterizedType((ParameterizedType)type, field, parent);
        } else if (type instanceof TypeVariable) {
            node = this.fromTypeVariable((TypeVariable)type, field, parent);
        } else if (type instanceof WildcardType) {
            node = this.fromWildcardType((WildcardType)type, field, parent);
        } else if (type instanceof GenericArrayType) {
            node = this.fromGenericArrayNode((GenericArrayType)type, field, parent);
        } else {
            throw new InstancioException("Unsupported type: " + type.getClass());
        }
        LOG.trace("Created node: {}", (Object)node);
        return node;
    }

    private Node fromWildcardType(WildcardType type, @Nullable Field field, @Nullable Node parent) {
        return this.createNode(type.getUpperBounds()[0], field, parent);
    }

    private Node fromTypeVariable(TypeVariable<?> type, @Nullable Field field, @Nullable Node parent) {
        Type resolvedType = this.resolveTypeVariable(type, parent);
        if (resolvedType == null) {
            LOG.warn("Unable to resolve type variable '{}'. Parent: {}", type, (Object)parent);
            return null;
        }
        return this.createNode(resolvedType, field, parent);
    }

    private Optional<Class<?>> resolveSubtype(Node node) {
        Optional<Class<?>> subtype = this.nodeContext.getSubtype(node);
        if (subtype.isPresent()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Resolved subtype: {} -> {}", (Object)node.getRawType().getName(), (Object)subtype.get().getName());
            }
            return subtype;
        }
        return Optional.ofNullable(NodeFactory.resolveSubtypeFromAncestors(node));
    }

    private static Class<?> resolveSubtypeFromAncestors(Node node) {
        for (Node next = node; next != null; next = next.getParent()) {
            Type actualType = next.getTypeMap().getActualType(node.getRawType());
            if (actualType == null) continue;
            return TypeUtils.getRawType(actualType);
        }
        return null;
    }

    private Node createNodeWithSubtypeMapping(Type type, @Nullable Field field, @Nullable Node parent) {
        Class rawType = TypeUtils.getRawType(type);
        Node node = Node.builder().nodeContext(this.nodeContext).type(type).rawType(rawType).targetClass(rawType).field(field).parent(parent).nodeKind(this.getNodeKind(rawType)).build();
        Class targetClass = this.resolveSubtype(node).orElse(rawType);
        Map<Type, Type> genericSuperclassTypeMap = NodeFactory.createSuperclassTypeMap(targetClass);
        if (!genericSuperclassTypeMap.isEmpty()) {
            node = node.toBuilder().additionalTypeMap(genericSuperclassTypeMap).build();
        }
        if (!rawType.isPrimitive() && rawType != targetClass && !targetClass.isEnum()) {
            ApiValidator.validateSubtype(rawType, targetClass);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Subtype mapping '{}' to '{}'", (Object)Format.withoutPackage(rawType), (Object)Format.withoutPackage(targetClass));
            }
            return node.toBuilder().targetClass(targetClass).nodeKind(this.getNodeKind(targetClass)).additionalTypeMap(NodeFactory.createBridgeTypeMap(rawType, targetClass)).build();
        }
        return node;
    }

    private Node fromClass(Class<?> type, @Nullable Field field, @Nullable Node parent) {
        Node node = this.createNodeWithSubtypeMapping(type, field, parent);
        if (node.hasAncestorEqualToSelf()) {
            return null;
        }
        Class<?> targetClass = node.getTargetClass();
        if (NodeFactory.isContainer(node)) {
            Type[] types;
            Type[] typeArray;
            if (targetClass.isArray()) {
                Type[] typeArray2 = new Type[1];
                typeArray = typeArray2;
                typeArray2[0] = targetClass.getComponentType();
            } else {
                typeArray = types = targetClass.getTypeParameters();
            }
            if (types.length == 0) {
                types = TypeUtils.getGenericSuperclassTypeArguments(targetClass);
            }
            List<Node> children = this.createContainerNodeChildren(node, types);
            node.setChildren(children);
        } else {
            List<Node> children = this.createChildrenFromFields(targetClass, node);
            node.setChildren(children);
        }
        return node;
    }

    private NodeKind getNodeKind(Class<?> rawType) {
        for (NodeKindResolver resolver : this.nodeContext.getNodeKindResolvers()) {
            Optional<NodeKind> resolve = resolver.resolve(rawType);
            if (!resolve.isPresent()) continue;
            return resolve.get();
        }
        return NodeKind.DEFAULT;
    }

    private Node fromParameterizedType(ParameterizedType type, @Nullable Field field, @Nullable Node parent) {
        Node node = this.createNodeWithSubtypeMapping(type, field, parent);
        if (node.hasAncestorEqualToSelf()) {
            return null;
        }
        List<Node> children = NodeFactory.isContainer(node) ? this.createContainerNodeChildren(node, type.getActualTypeArguments()) : this.createChildrenFromFields(node.getTargetClass(), node);
        node.setChildren(children);
        return node;
    }

    private Node fromGenericArrayNode(GenericArrayType type, @Nullable Field field, @Nullable Node parent) {
        Type gcType = type.getGenericComponentType();
        if (gcType instanceof TypeVariable) {
            gcType = this.resolveTypeVariable((TypeVariable)gcType, parent);
        }
        Node node = this.createArrayNodeWithSubtypeMapping(type, gcType, field, parent);
        List<Node> children = this.createContainerNodeChildren(node, gcType);
        node.setChildren(children);
        return node;
    }

    private Node createArrayNodeWithSubtypeMapping(Type arrayType, Type genericComponentType, @Nullable Field field, @Nullable Node parent) {
        Class rawComponentType = TypeUtils.getRawType(genericComponentType);
        Node node = Node.builder().nodeContext(this.nodeContext).type(arrayType).rawType(TypeUtils.getArrayClass(rawComponentType)).targetClass(TypeUtils.getArrayClass(rawComponentType)).field(field).parent(parent).nodeKind(NodeKind.ARRAY).build();
        Class targetClass = this.resolveSubtype(node).orElse(rawComponentType);
        Class<?> targetClassComponentType = targetClass.getComponentType();
        if (!rawComponentType.isPrimitive() && targetClassComponentType != null && rawComponentType != targetClassComponentType) {
            ApiValidator.validateSubtype(rawComponentType, targetClassComponentType);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Subtype mapping '{}' to '{}'", (Object)Format.withoutPackage(rawComponentType), (Object)Format.withoutPackage(targetClass));
            }
            Map<Type, Type> typeMapForSubtype = NodeFactory.createBridgeTypeMap(rawComponentType, targetClassComponentType);
            typeMapForSubtype.put(rawComponentType, targetClassComponentType);
            return node.toBuilder().targetClass(targetClass).additionalTypeMap(typeMapForSubtype).build();
        }
        return node;
    }

    private List<Node> createContainerNodeChildren(Node parent, Type ... types) {
        ArrayList<Node> results = new ArrayList<Node>(types.length);
        for (Type type : types) {
            Node node = this.createNode(type, null, parent);
            if (node == null) continue;
            results.add(node);
        }
        return results;
    }

    private List<Node> createChildrenFromFields(Class<?> targetClass, Node parent) {
        ArrayList<Node> list = new ArrayList<Node>();
        for (Field f : this.fieldCollector.getFields(targetClass)) {
            Node node = this.createNode(ObjectUtils.defaultIfNull(f.getGenericType(), f.getType()), f, parent);
            if (node == null) continue;
            list.add(node);
        }
        return list;
    }

    private static boolean isContainer(Node node) {
        return node.is(NodeKind.COLLECTION) || node.is(NodeKind.MAP) || node.is(NodeKind.ARRAY) || node.is(NodeKind.CONTAINER);
    }

    private Type resolveTypeVariable(TypeVariable<?> typeVar, @Nullable Node parent) {
        Type mappedType = parent == null ? typeVar : parent.getTypeMap().getOrDefault(typeVar, typeVar);
        for (Node ancestor = parent; (mappedType == null || mappedType instanceof TypeVariable) && ancestor != null; ancestor = ancestor.getParent()) {
            Type rootTypeMapping = this.nodeContext.getRootTypeMap().get(mappedType);
            if (rootTypeMapping != null) {
                return rootTypeMapping;
            }
            mappedType = ancestor.getTypeMap().getOrDefault(mappedType, mappedType);
            if (mappedType instanceof Class || mappedType instanceof ParameterizedType) break;
        }
        return mappedType == typeVar ? null : mappedType;
    }

    private static Map<Type, Type> createSuperclassTypeMap(Class<?> targetClass) {
        HashMap<Type, Type> resultTypeMap = null;
        Type supertype = targetClass.getGenericSuperclass();
        while (supertype instanceof ParameterizedType) {
            if (resultTypeMap == null) {
                resultTypeMap = new HashMap<Type, Type>();
            }
            NodeFactory.addTypeParameters((ParameterizedType)supertype, resultTypeMap);
            Class rawSuper = TypeUtils.getRawType(supertype);
            supertype = rawSuper.getGenericSuperclass();
        }
        if (resultTypeMap == null) {
            return Collections.emptyMap();
        }
        LOG.trace("Created superclass type map: {}", resultTypeMap);
        return resultTypeMap;
    }

    private static Map<Type, Type> createBridgeTypeMap(Class<?> source, Class<?> target) {
        Type supertype;
        TypeVariable<Class<?>>[] supertypeParams;
        if (source.equals(target)) {
            return Collections.emptyMap();
        }
        HashMap<Type, Type> typeMap = new HashMap<Type, Type>();
        TypeVariable<Class<?>>[] subtypeParams = target.getTypeParameters();
        if (subtypeParams.length == (supertypeParams = source.getTypeParameters()).length) {
            for (int i = 0; i < subtypeParams.length; ++i) {
                typeMap.put(subtypeParams[i], supertypeParams[i]);
            }
        }
        if ((supertype = target.getGenericSuperclass()) instanceof ParameterizedType) {
            NodeFactory.addTypeParameters((ParameterizedType)supertype, typeMap);
        }
        return typeMap;
    }

    private static void addTypeParameters(ParameterizedType parameterizedType, Map<Type, Type> typeMap) {
        Type[] typeArgs;
        Class rawSuperclassType = TypeUtils.getRawType(parameterizedType);
        TypeVariable<Class<T>>[] typeVars = rawSuperclassType.getTypeParameters();
        if (typeVars.length == (typeArgs = parameterizedType.getActualTypeArguments()).length) {
            for (int i = 0; i < typeVars.length; ++i) {
                typeMap.put(typeVars[i], typeArgs[i]);
            }
        }
    }
}

