/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.reflection.instantiation;

import org.instancio.internal.reflection.instantiation.InstantiationStrategy;
import org.instancio.internal.reflection.instantiation.NoArgumentConstructorInstantiationStrategy;
import org.instancio.internal.reflection.instantiation.ObjenesisInstantiationStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Instantiator {
    private static final Logger LOG = LoggerFactory.getLogger(Instantiator.class);
    private final InstantiationStrategy[] strategies = new InstantiationStrategy[]{new NoArgumentConstructorInstantiationStrategy(), new ObjenesisInstantiationStrategy()};

    public <T> T instantiate(Class<T> klass) {
        for (InstantiationStrategy strategy : this.strategies) {
            T instance = this.createInstance(klass, strategy);
            if (instance == null) continue;
            return instance;
        }
        LOG.debug("Could not instantiate class '{}'", (Object)klass.getName());
        return null;
    }

    private <T> T createInstance(Class<T> klass, InstantiationStrategy strategy) {
        try {
            return strategy.createInstance(klass);
        }
        catch (Throwable ex) {
            LOG.trace("'{}' failed instantiating class '{}'", new Object[]{strategy.getClass().getSimpleName(), klass.getName(), ex});
            return null;
        }
    }
}

