/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.settings;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.instancio.exception.InstancioApiException;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.settings.SettingsSupport;
import org.instancio.internal.util.ReflectionUtils;
import org.instancio.internal.util.Verify;
import org.instancio.settings.Keys;
import org.instancio.settings.SettingKey;
import org.instancio.settings.Settings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InternalSettings
implements Settings {
    private static final String TYPE_MAPPING_PREFIX = "subtype.";
    private static final boolean AUTO_ADJUST_ENABLED = true;
    private boolean isLockedForModifications;
    private Map<SettingKey, Object> settingsMap = new HashMap<SettingKey, Object>();
    private Map<Class<?>, Class<?>> subtypeMap = new HashMap();

    InternalSettings() {
    }

    public static InternalSettings create() {
        return new InternalSettings();
    }

    public static InternalSettings defaults() {
        InternalSettings settings = new InternalSettings();
        for (SettingKey setting : Keys.all()) {
            settings.set(setting, setting.defaultValue());
        }
        return settings;
    }

    public static InternalSettings from(Map<Object, Object> map) {
        InternalSettings settings = new InternalSettings();
        map.forEach((k, v) -> {
            String key = k.toString();
            if (key.startsWith(TYPE_MAPPING_PREFIX)) {
                String fromClass = key.replace(TYPE_MAPPING_PREFIX, "");
                settings.mapType((Class)ReflectionUtils.getClass(fromClass), (Class)ReflectionUtils.getClass(v.toString()));
            } else {
                Object val;
                SettingKey settingKey = Keys.get(key);
                Function<String, Object> fn = SettingsSupport.getFunction(settingKey.type());
                try {
                    val = fn.apply(v.toString());
                }
                catch (NumberFormatException ex) {
                    throw new InstancioApiException("Invalid value for setting key: " + settingKey, ex);
                }
                settings.set(settingKey, val);
            }
        });
        return settings;
    }

    public static InternalSettings from(Settings other) {
        InternalSettings settings = new InternalSettings();
        settings.settingsMap.putAll(((InternalSettings)other).settingsMap);
        settings.subtypeMap.putAll(((InternalSettings)other).subtypeMap);
        return settings;
    }

    @Override
    public InternalSettings merge(@Nullable Settings other) {
        InternalSettings merged = InternalSettings.create();
        merged.settingsMap.putAll(this.settingsMap);
        merged.subtypeMap.putAll(this.subtypeMap);
        if (other != null) {
            merged.settingsMap.putAll(((InternalSettings)other).settingsMap);
            merged.subtypeMap.putAll(((InternalSettings)other).subtypeMap);
        }
        return merged;
    }

    @Override
    public <T> T get(@NotNull SettingKey key) {
        return (T)this.settingsMap.get(Verify.notNull(key, "Key must not be null", new Object[0]));
    }

    @Override
    public InternalSettings set(@NotNull SettingKey key, @Nullable Object value) {
        return this.set(key, value, true);
    }

    InternalSettings set(@NotNull SettingKey key, @Nullable Object value, boolean autoAdjust) {
        this.checkLockedForModifications();
        ApiValidator.validateKeyValue(key, value);
        this.settingsMap.put(key, value);
        if (autoAdjust) {
            SettingsSupport.getAutoAdjustable(key).ifPresent(k -> k.autoAdjust(this, new NumberCaster().cast(value)));
        }
        return this;
    }

    @Override
    public InternalSettings mapType(@NotNull Class<?> from, @NotNull Class<?> to) {
        this.checkLockedForModifications();
        ApiValidator.validateSubtype(from, to);
        this.subtypeMap.put(from, to);
        return this;
    }

    @Override
    public Map<Class<?>, Class<?>> getSubtypeMap() {
        return Collections.unmodifiableMap(this.subtypeMap);
    }

    @Override
    public InternalSettings lock() {
        if (!this.isLockedForModifications) {
            this.settingsMap = Collections.unmodifiableMap(this.settingsMap);
            this.subtypeMap = Collections.unmodifiableMap(this.subtypeMap);
            this.isLockedForModifications = true;
        }
        return this;
    }

    private void checkLockedForModifications() {
        if (this.isLockedForModifications) {
            throw new UnsupportedOperationException("This instance of Settings has been locked and is read-only");
        }
    }

    public String toString() {
        return String.format("Settings[%nisLockedForModifications: %s%nsettingsMap:%s%nsubtypeMap:%s", this.isLockedForModifications, InternalSettings.mapToString(new TreeMap<SettingKey, Object>(this.settingsMap)), InternalSettings.mapToString(this.subtypeMap));
    }

    private static String mapToString(Map<?, ?> map) {
        if (map.isEmpty()) {
            return " {}";
        }
        return "\n" + map.entrySet().stream().map(e -> String.format("\t'%s': %s", e.getKey(), e.getValue())).collect(Collectors.joining("\n"));
    }

    private static class NumberCaster<T extends Number> {
        private NumberCaster() {
        }

        private T cast(Object obj) {
            return (T)((Number)obj);
        }
    }
}

