/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.util;

import java.lang.reflect.Field;
import org.instancio.generator.GeneratorSpec;
import org.instancio.generator.specs.NumberGeneratorSpec;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.generator.lang.AbstractRandomNumberGeneratorSpec;
import org.instancio.internal.util.IntRange;

public final class BeanValidationUtils {
    private BeanValidationUtils() {
    }

    public static IntRange calculateRange(int min, int max, int maxLimit) {
        int maxSize;
        int minSize;
        ApiValidator.isTrue(min <= max, "Invalid bean validation annotation: min must be less than or equal to max: min=%s, max=%s", min, max);
        if (max == 0) {
            minSize = 0;
            maxSize = 0;
        } else if (min == 0) {
            minSize = 1;
            maxSize = Math.min(max, maxLimit);
        } else if (BeanValidationUtils.isMoreThanDouble(min, max)) {
            int tmpMax = min * 150 / 100;
            minSize = min;
            maxSize = Math.min(max, tmpMax);
        } else {
            minSize = min;
            maxSize = max;
        }
        return IntRange.range(minSize, maxSize);
    }

    private static boolean isMoreThanDouble(int min, int max) {
        return max - min - min > 0;
    }

    public static void setNonNullablePrimitive(GeneratorSpec<?> spec, Field field) {
        if (spec instanceof NumberGeneratorSpec && field.getType().isPrimitive()) {
            ((AbstractRandomNumberGeneratorSpec)spec).nullable(false);
        }
    }
}

