/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.util;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.instancio.exception.InstancioException;
import org.instancio.internal.util.ExceptionHandler;
import org.instancio.internal.util.Verify;
import org.jetbrains.annotations.Nullable;

public final class TypeUtils {
    private TypeUtils() {
    }

    public static Class<?> getArrayClass(@Nullable Type type) {
        if (type instanceof Class) {
            Class klass = (Class)type;
            if (klass.isArray()) {
                return klass;
            }
            return Array.newInstance(klass, 0).getClass();
        }
        if (type instanceof ParameterizedType) {
            Type rawType = ((ParameterizedType)type).getRawType();
            return TypeUtils.getArrayClass(rawType);
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)type;
            Type genericComponent = arrayType.getGenericComponentType();
            return Array.newInstance(TypeUtils.getRawType(genericComponent), 0).getClass();
        }
        throw new IllegalArgumentException("Not an array: " + type);
    }

    public static Type[] getTypeArguments(Type parameterizedType) {
        ParameterizedType pType = (ParameterizedType)parameterizedType;
        return pType.getActualTypeArguments();
    }

    public static <T> Class<T> getRawType(Type type) {
        Verify.notNull(type, "type is null", new Object[0]);
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        if (type instanceof GenericArrayType) {
            Type genericComponentType = ((GenericArrayType)type).getGenericComponentType();
            return TypeUtils.getRawType(genericComponentType);
        }
        ExceptionHandler.conditionalFailOnError(() -> {
            throw new InstancioException("Unhandled type: " + type.getClass().getSimpleName());
        });
        return null;
    }

    public static Class<?> getGenericSuperclassTypeArgument(Class<?> klass) {
        if (klass.getGenericSuperclass() instanceof ParameterizedType) {
            ParameterizedType genericSuperclass = (ParameterizedType)klass.getGenericSuperclass();
            Type genericType = genericSuperclass.getActualTypeArguments()[0];
            return TypeUtils.getRawType(genericType);
        }
        for (Type type : klass.getGenericInterfaces()) {
            if (!(type instanceof ParameterizedType)) continue;
            ParameterizedType genericSuperclass = (ParameterizedType)type;
            Type genericType = genericSuperclass.getActualTypeArguments()[0];
            return TypeUtils.getRawType(genericType);
        }
        return null;
    }

    public static Type[] getGenericSuperclassTypeArguments(Class<?> klass) {
        if (klass.getGenericSuperclass() instanceof ParameterizedType) {
            ParameterizedType genericSuperclass = (ParameterizedType)klass.getGenericSuperclass();
            return genericSuperclass.getActualTypeArguments();
        }
        return new Type[0];
    }
}

