/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal;

import java.util.Set;
import org.instancio.generator.GeneratorContext;
import org.instancio.internal.GeneratedObjectStore;
import org.instancio.internal.GeneratedPojoStore;
import org.instancio.internal.GeneratorSpecProcessor;
import org.instancio.internal.assignment.InternalAssignment;
import org.instancio.internal.beanvalidation.BeanValidationProcessor;
import org.instancio.internal.beanvalidation.NoopBeanValidationProvider;
import org.instancio.internal.context.ModelContext;
import org.instancio.internal.generator.GeneratorResolver;
import org.instancio.internal.generator.GeneratorResult;
import org.instancio.internal.handlers.AssignmentNodeHandler;
import org.instancio.internal.handlers.CollectionNodeHandler;
import org.instancio.internal.handlers.InstantiatingHandler;
import org.instancio.internal.handlers.MapNodeHandler;
import org.instancio.internal.handlers.NodeHandler;
import org.instancio.internal.handlers.UserSuppliedGeneratorHandler;
import org.instancio.internal.handlers.UsingGeneratorResolverHandler;
import org.instancio.internal.instantiation.Instantiator;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.settings.Keys;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GeneratorFacade {
    private static final Logger LOG = LoggerFactory.getLogger(GeneratorFacade.class);
    private final ModelContext<?> context;
    private final NodeHandler[] nodeHandlers;
    private final AssignmentNodeHandler assignmentNodeHandler;
    private final NodeHandler userSuppliedGeneratorHandler;
    private final GeneratedPojoStore generatedPojoStore;

    GeneratorFacade(ModelContext<?> context, GeneratedObjectStore generatedObjectStore) {
        this.context = context;
        this.generatedPojoStore = GeneratedPojoStore.createStore(context);
        GeneratorContext generatorContext = new GeneratorContext(context.getSettings(), context.getRandom());
        GeneratorSpecProcessor beanValidationProcessor = this.getGeneratorSpecProcessor();
        GeneratorResolver generatorResolver = new GeneratorResolver(generatorContext, context.getServiceProviders().getGeneratorProviders());
        Instantiator instantiator = new Instantiator(context.getServiceProviders().getTypeInstantiators());
        this.assignmentNodeHandler = new AssignmentNodeHandler(context, generatedObjectStore, generatorResolver, instantiator);
        this.userSuppliedGeneratorHandler = new UserSuppliedGeneratorHandler(context, generatorResolver, instantiator);
        this.nodeHandlers = new NodeHandler[]{this.assignmentNodeHandler, this.userSuppliedGeneratorHandler, new UsingGeneratorResolverHandler(context, generatorResolver, beanValidationProcessor), new CollectionNodeHandler(context, beanValidationProcessor), new MapNodeHandler(context, beanValidationProcessor), new InstantiatingHandler(instantiator)};
    }

    Set<InternalAssignment> getUnresolvedAssignments() {
        return this.assignmentNodeHandler.getUnresolvedAssignments();
    }

    private GeneratorSpecProcessor getGeneratorSpecProcessor() {
        boolean isEnabled = this.context.getSettings().get(Keys.BEAN_VALIDATION_ENABLED);
        LOG.trace("Keys.BEAN_VALIDATION_ENABLED={}", (Object)isEnabled);
        return isEnabled ? new BeanValidationProcessor() : new NoopBeanValidationProvider();
    }

    private boolean shouldReturnNullForNullable(InternalNode node) {
        boolean precondition = this.context.isNullable(node);
        return this.context.getRandom().diceRoll(precondition);
    }

    GeneratorResult generateNodeValue(InternalNode node) {
        GeneratorResult result = GeneratorResult.emptyResult();
        if (node.isIgnored()) {
            result = GeneratorResult.ignoredResult();
        } else if (this.shouldReturnNullForNullable(node)) {
            result = GeneratorResult.nullResult();
        } else if (node.isCyclic()) {
            result = this.assignmentNodeHandler.getResult(node);
            if (result.isEmpty()) {
                result = this.userSuppliedGeneratorHandler.getResult(node);
            }
            if (result.isEmpty()) {
                result = this.generatedPojoStore.getParentObject(node);
            }
        } else {
            NodeHandler handler;
            NodeHandler[] nodeHandlerArray = this.nodeHandlers;
            int n = nodeHandlerArray.length;
            for (int i = 0; i < n && (result = (handler = nodeHandlerArray[i]).getResult(node)).isEmpty() && !result.isDelayed(); ++i) {
            }
        }
        this.generatedPojoStore.putValue(node, result);
        LOG.trace("{} - {}", (Object)node, (Object)result);
        return result;
    }
}

