/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.context;

import java.util.Collections;
import java.util.Set;
import org.instancio.TargetSelector;
import org.instancio.internal.Flattener;
import org.instancio.internal.context.SelectorMap;
import org.instancio.internal.context.SelectorMapImpl;
import org.instancio.internal.nodes.InternalNode;
import org.jetbrains.annotations.NotNull;

public class BooleanSelectorMap {
    private final Set<TargetSelector> targetSelectors;
    private final SelectorMap<Boolean> selectorMap;

    public BooleanSelectorMap(@NotNull Set<TargetSelector> targetSelectors) {
        this.targetSelectors = Collections.unmodifiableSet(targetSelectors);
        this.selectorMap = targetSelectors.isEmpty() ? SelectorMapImpl.emptyMap() : new SelectorMapImpl();
        this.putAll(targetSelectors);
    }

    private void putAll(Set<TargetSelector> targetSelectors) {
        for (TargetSelector targetSelector : targetSelectors) {
            for (TargetSelector target : ((Flattener)((Object)targetSelector)).flatten()) {
                this.selectorMap.put(target, true);
            }
        }
    }

    public SelectorMap<Boolean> getSelectorMap() {
        return this.selectorMap;
    }

    public Set<TargetSelector> getOriginSelectors(InternalNode node) {
        return this.selectorMap.getSelectors(node);
    }

    Set<TargetSelector> getTargetSelectors() {
        return this.targetSelectors;
    }

    public boolean isTrue(InternalNode node) {
        return Boolean.TRUE.equals(this.selectorMap.getValue(node).orElse(false));
    }
}

