/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.handlers;

import org.instancio.generator.Generator;
import org.instancio.generator.Hints;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.context.ModelContext;
import org.instancio.internal.generator.AbstractGenerator;
import org.instancio.internal.generator.GeneratorResolver;
import org.instancio.internal.generator.GeneratorResult;
import org.instancio.internal.generator.InternalGeneratorHint;
import org.instancio.internal.generator.array.ArrayGenerator;
import org.instancio.internal.generator.misc.EmitGenerator;
import org.instancio.internal.generator.misc.GeneratorDecorator;
import org.instancio.internal.generator.misc.InstantiatingGenerator;
import org.instancio.internal.handlers.EmitGeneratorHelper;
import org.instancio.internal.instantiation.Instantiator;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.internal.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;

final class UserSuppliedGeneratorProcessor {
    private final ModelContext<?> context;
    private final GeneratorResolver generatorResolver;
    private final Instantiator instantiator;

    UserSuppliedGeneratorProcessor(ModelContext<?> context, GeneratorResolver generatorResolver, Instantiator instantiator) {
        this.context = context;
        this.generatorResolver = generatorResolver;
        this.instantiator = instantiator;
    }

    GeneratorResult getGeneratorResult(@NotNull InternalNode node, Generator<?> g) {
        boolean nullable;
        Generator<?> generator = this.processGenerator(g, node);
        if (generator instanceof EmitGenerator) {
            EmitGeneratorHelper helper = new EmitGeneratorHelper(this.context);
            return helper.getResult((EmitGenerator)generator, node);
        }
        Hints hints = generator.hints();
        InternalGeneratorHint internalHint = hints.get(InternalGeneratorHint.class);
        boolean bl = nullable = internalHint != null && internalHint.nullableResult();
        if (this.context.getRandom().diceRoll(nullable)) {
            return GeneratorResult.nullResult();
        }
        Object value = generator.generate(this.context.getRandom());
        return GeneratorResult.create(value, hints);
    }

    private Generator<?> processGenerator(Generator<?> generator, InternalNode node) {
        Hints hints;
        InternalGeneratorHint internalHint;
        ApiValidator.validateGeneratorUsage(node, generator);
        if (generator instanceof ArrayGenerator) {
            ((ArrayGenerator)generator).subtype((Class)node.getTargetClass());
        }
        if ((internalHint = (hints = generator.hints()).get(InternalGeneratorHint.class)) == null || !internalHint.isDelegating()) {
            return generator;
        }
        Generator<?> delegate = this.resolveDelegate(node, internalHint);
        if (delegate instanceof AbstractGenerator) {
            boolean nullable = ((AbstractGenerator)generator).isNullable();
            ((AbstractGenerator)delegate).nullable(nullable);
        }
        return GeneratorDecorator.replaceHints(delegate, hints);
    }

    @NotNull
    private Generator<?> resolveDelegate(InternalNode node, InternalGeneratorHint internalHint) {
        Class<?> forClass = ObjectUtils.defaultIfNull(internalHint.targetClass(), node.getTargetClass());
        InternalNode actualNode = forClass == node.getTargetClass() ? node : node.toBuilder().targetClass(forClass).build();
        return this.generatorResolver.get(actualNode).orElse(new InstantiatingGenerator(this.instantiator, forClass));
    }
}

