/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.util;

import java.lang.reflect.Field;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.internal.util.Constants;
import org.instancio.internal.util.Format;
import org.instancio.internal.util.StringUtils;
import org.instancio.settings.AssignmentType;
import org.instancio.settings.Keys;
import org.instancio.settings.OnSetFieldError;
import org.instancio.settings.OnSetMethodError;
import org.instancio.settings.OnSetMethodNotFound;
import org.instancio.settings.SetterStyle;
import org.instancio.settings.Settings;

public final class AssignerErrorUtil {
    private static final int INITIAL_SB_SIZE = 1024;

    private AssignerErrorUtil() {
    }

    public static String getTypeMismatchErrorMessage(Object value, InternalNode node) {
        return AssignerErrorUtil.getTypeMismatchErrorMessage(value, node, null);
    }

    public static String getTypeMismatchErrorMessage(Object value, InternalNode node, Throwable cause) {
        StringBuilder sb = new StringBuilder(1024);
        AssignerErrorUtil.appendNodeDetails("error assigning value to: ", node, sb);
        AssignerErrorUtil.appendTypeMismatchDetails(value, node, sb);
        if (cause != null) {
            sb.append(Constants.NL).append(Constants.NL).append("Root cause:").append(Constants.NL).append(" -> ").append(AssignerErrorUtil.getRootCause(cause));
        }
        return sb.toString();
    }

    public static String getContainerElementMismatchMessage(String errorMsg, Object value, InternalNode containerNode, InternalNode elementNode) {
        StringBuilder sb = new StringBuilder(1024);
        AssignerErrorUtil.appendNodeDetails(errorMsg + ": ", containerNode, sb);
        AssignerErrorUtil.appendTypeMismatchDetails(value, elementNode, sb);
        return sb.toString();
    }

    private static void appendNodeDetails(String errorHeader, InternalNode node, StringBuilder sb) {
        sb.append(errorHeader).append(node.toDisplayString()).append(" (depth=").append(node.getDepth()).append(')').append(Constants.NL).append(Constants.NL).append(" \u2502 Path to root:").append(Constants.NL).append(Format.nodePathToRoot(node, " \u2502   ")).append("   <-- Root").append(Constants.NL).append(" \u2502").append(Constants.NL).append(" \u2502 Format: <depth:class: field>").append(Constants.NL).append(Constants.NL).append(Constants.NL);
    }

    private static void appendTypeMismatchDetails(Object value, InternalNode node, StringBuilder sb) {
        String nodeDescription = Format.formatNode(node);
        String argType = Format.withoutPackage(value.getClass());
        String argValue = StringUtils.quoteToString(value);
        sb.append("Type mismatch:").append(Constants.NL).append(Constants.NL);
        if (node.getField() == null) {
            sb.append(" -> Target type ..............: ");
        } else {
            sb.append(" -> Target field .............: ");
        }
        sb.append(nodeDescription).append(Constants.NL).append(" -> Provided argument type ...: ").append(argType).append(Constants.NL).append(" -> Provided argument value ..: ").append(argValue);
    }

    public static String incompatibleField(Object value, Field field, Throwable cause, Settings settings) {
        OnSetFieldError onSetFieldError = settings.get(Keys.ON_SET_FIELD_ERROR);
        String fieldName = Format.formatField(field);
        String argType = Format.withoutPackage(value.getClass());
        String argValue = StringUtils.quoteToString(value);
        return new StringBuilder(1024).append(Constants.NL).append("Throwing exception because:").append(Constants.NL).append(" -> Keys.ON_SET_FIELD_ERROR = ").append((Object)onSetFieldError).append(Constants.NL).append(Constants.NL).append("Error assigning value to field:").append(Constants.NL).append(Constants.NL).append(" -> Target field: ............: ").append(fieldName).append(Constants.NL).append(" -> Provided argument type ...: ").append(argType).append(Constants.NL).append(" -> Provided argument value ..: ").append(argValue).append(Constants.NL).append(Constants.NL).append("Root cause:").append(Constants.NL).append(" -> ").append(AssignerErrorUtil.getRootCause(cause)).append(Constants.NL).append(Constants.NL).append("To ignore the error and leave the field uninitialised").append(Constants.NL).append(" -> Update Keys.ON_SET_FIELD_ERROR setting to: ").append((Object)OnSetFieldError.IGNORE).append(Constants.NL).toString();
    }

    public static String setterNotFound(Field field, String expectedMethodName, Settings settings) {
        String fieldName = Format.formatField(field);
        SetterStyle setterStyle = settings.get(Keys.SETTER_STYLE);
        OnSetMethodNotFound onSetMethodNotFound = settings.get(Keys.ON_SET_METHOD_NOT_FOUND);
        return new StringBuilder(1024).append(Constants.NL).append("Throwing exception because:").append(Constants.NL).append(" -> Keys.ASSIGNMENT_TYPE = ").append((Object)AssignmentType.METHOD).append(Constants.NL).append(" -> Keys.ON_SET_METHOD_NOT_FOUND = ").append((Object)onSetMethodNotFound).append(Constants.NL).append(Constants.NL).append("Setter method could not be resolved for field:").append(Constants.NL).append(" -> ").append(fieldName).append(Constants.NL).append(Constants.NL).append("Using:").append(Constants.NL).append(" -> Keys.SETTER_STYLE = ").append((Object)setterStyle).append(Constants.NL).append(" -> Expected method name: '").append(expectedMethodName).append('\'').append(Constants.NL).append(Constants.NL).append("To resolve the error, consider one of the following:").append(Constants.NL).append(" -> Add the expected setter method").append(Constants.NL).append(" -> Update Keys.ON_SET_METHOD_NOT_FOUND setting to:").append(Constants.NL).append("    -> ").append((Object)OnSetMethodNotFound.ASSIGN_FIELD).append(" to assign value via field").append(Constants.NL).append("    -> ").append((Object)OnSetMethodNotFound.IGNORE).append(" to leave value uninitialised").append(Constants.NL).toString();
    }

    public static String getSetterInvocationErrorMessage(Object value, String method, Throwable cause, Settings settings) {
        OnSetMethodError onSetMethodError = settings.get(Keys.ON_SET_METHOD_ERROR);
        String argType = Format.withoutPackage(value.getClass());
        String argValue = StringUtils.quoteToString(value);
        return new StringBuilder(1024).append(Constants.NL).append("Throwing exception because:").append(Constants.NL).append(" -> Keys.ASSIGNMENT_TYPE = ").append((Object)AssignmentType.METHOD).append(Constants.NL).append(" -> Keys.ON_SET_METHOD_ERROR = ").append((Object)onSetMethodError).append(Constants.NL).append(Constants.NL).append("Method invocation failed:").append(Constants.NL).append(Constants.NL).append(" -> Method ...................: ").append(method).append(Constants.NL).append(" -> Provided argument type ...: ").append(argType).append(Constants.NL).append(" -> Provided argument value ..: ").append(argValue).append(Constants.NL).append(Constants.NL).append("Root cause:").append(Constants.NL).append(" -> ").append(AssignerErrorUtil.getRootCause(cause)).append(Constants.NL).append(Constants.NL).append("To resolve the error, consider one of the following:").append(Constants.NL).append(" -> Address the root cause that triggered the exception").append(Constants.NL).append(" -> Update Keys.ON_SET_METHOD_ERROR setting to").append(Constants.NL).append("    -> ").append((Object)OnSetMethodError.ASSIGN_FIELD).append(" to assign value via field").append(Constants.NL).append("    -> ").append((Object)OnSetMethodError.IGNORE).append(" to leave value uninitialised").append(Constants.NL).toString();
    }

    private static Throwable getRootCause(Throwable t) {
        Throwable cause = t;
        while (cause.getCause() != null) {
            cause = cause.getCause();
        }
        return cause;
    }
}

