/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.util;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.instancio.exception.InstancioException;
import org.instancio.internal.util.ExceptionHandler;
import org.instancio.internal.util.Verify;
import org.jetbrains.annotations.Nullable;

public final class TypeUtils {
    private TypeUtils() {
    }

    public static int getTypeParameterCount(Class<?> klass) {
        return klass.isArray() ? klass.getComponentType().getTypeParameters().length : klass.getTypeParameters().length;
    }

    public static Class<?> getArrayClass(@Nullable Type type) {
        if (type instanceof Class) {
            Class klass = (Class)type;
            if (klass.isArray()) {
                return klass;
            }
            return Array.newInstance(klass, 0).getClass();
        }
        if (type instanceof ParameterizedType) {
            Type rawType = ((ParameterizedType)type).getRawType();
            return TypeUtils.getArrayClass(rawType);
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)type;
            Type genericComponent = arrayType.getGenericComponentType();
            return Array.newInstance(TypeUtils.getRawType(genericComponent), 0).getClass();
        }
        throw new IllegalArgumentException("Could not resolve array class for type: " + type);
    }

    @Nullable
    public static <T> Class<T> getRawType(Type type) {
        Verify.notNull(type, "null type", new Object[0]);
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        if (type instanceof GenericArrayType) {
            Type genericComponentType = ((GenericArrayType)type).getGenericComponentType();
            return TypeUtils.getRawType(genericComponentType);
        }
        ExceptionHandler.conditionalFailOnError(() -> {
            throw new InstancioException("Unhandled type: " + type.getClass().getSimpleName());
        });
        return null;
    }

    @Nullable
    public static Class<?> getGenericSuperclassTypeArgument(Class<?> klass) {
        ParameterizedType type = TypeUtils.findParameterizedSupertype(klass);
        return type == null ? null : TypeUtils.getRawType(type.getActualTypeArguments()[0]);
    }

    @Nullable
    private static ParameterizedType findParameterizedSupertype(@Nullable Class<?> klass) {
        if (klass == null) {
            return null;
        }
        List<Type> supertypes = TypeUtils.collectSupertypes(klass);
        for (Type supertype : supertypes) {
            if (!(supertype instanceof ParameterizedType)) continue;
            return (ParameterizedType)supertype;
        }
        return TypeUtils.findParameterizedSupertype(supertypes);
    }

    private static List<Type> collectSupertypes(Class<?> klass) {
        Type genericSuperclass = klass.getGenericSuperclass();
        Type[] genericInterfaces = klass.getGenericInterfaces();
        if (genericSuperclass == null && genericInterfaces.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Type> supertypes = new ArrayList<Type>();
        if (genericSuperclass != null) {
            supertypes.add(genericSuperclass);
        }
        if (genericInterfaces.length > 0) {
            supertypes.addAll(Arrays.asList(genericInterfaces));
        }
        return supertypes;
    }

    private static ParameterizedType findParameterizedSupertype(List<Type> types) {
        for (Type type : types) {
            ParameterizedType pType = TypeUtils.findParameterizedSupertype(TypeUtils.getRawType(type));
            if (pType == null) continue;
            return pType;
        }
        return null;
    }

    public static Type[] getGenericSuperclassTypeArguments(Class<?> klass) {
        if (klass.getGenericSuperclass() instanceof ParameterizedType) {
            ParameterizedType genericSuperclass = (ParameterizedType)klass.getGenericSuperclass();
            return genericSuperclass.getActualTypeArguments();
        }
        return new Type[0];
    }
}

