/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.settings;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.instancio.documentation.ExperimentalApi;
import org.instancio.generator.AfterGenerate;
import org.instancio.internal.settings.InternalKey;
import org.instancio.internal.settings.RangeAdjuster;
import org.instancio.settings.AssignmentType;
import org.instancio.settings.Mode;
import org.instancio.settings.OnSetFieldError;
import org.instancio.settings.OnSetMethodError;
import org.instancio.settings.OnSetMethodNotFound;
import org.instancio.settings.SetterStyle;
import org.instancio.settings.SettingKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Keys {
    private static final RangeAdjuster MIN_ADJUSTER = RangeAdjuster.MIN_ADJUSTER;
    private static final RangeAdjuster MAX_ADJUSTER = RangeAdjuster.MAX_ADJUSTER;
    private static final List<SettingKey<Object>> ALL_KEYS = new ArrayList<SettingKey<Object>>();
    @ExperimentalApi
    public static final SettingKey<AssignmentType> ASSIGNMENT_TYPE = Keys.register("assignment.type", AssignmentType.class, (Object)AssignmentType.FIELD);
    public static final SettingKey<AfterGenerate> AFTER_GENERATE_HINT = Keys.register("hint.after.generate", AfterGenerate.class, (Object)AfterGenerate.POPULATE_NULLS_AND_DEFAULT_PRIMITIVES);
    public static final SettingKey<Boolean> ARRAY_ELEMENTS_NULLABLE = Keys.register("array.elements.nullable", Boolean.class, false);
    public static final SettingKey<Integer> ARRAY_MIN_LENGTH = Keys.register("array.min.length", Integer.class, 2, MIN_ADJUSTER);
    public static final SettingKey<Integer> ARRAY_MAX_LENGTH = Keys.register("array.max.length", Integer.class, 6, MAX_ADJUSTER);
    public static final SettingKey<Boolean> ARRAY_NULLABLE = Keys.register("array.nullable", Boolean.class, false);
    @ExperimentalApi
    public static final SettingKey<Boolean> BEAN_VALIDATION_ENABLED = Keys.register("bean.validation.enabled", Boolean.class, false);
    public static final SettingKey<Boolean> BOOLEAN_NULLABLE = Keys.register("boolean.nullable", Boolean.class, false);
    public static final SettingKey<Byte> BYTE_MIN = Keys.register("byte.min", Byte.class, (byte)1, MIN_ADJUSTER);
    public static final SettingKey<Byte> BYTE_MAX = Keys.register("byte.max", Byte.class, (byte)127, MAX_ADJUSTER);
    public static final SettingKey<Boolean> BYTE_NULLABLE = Keys.register("byte.nullable", Boolean.class, false);
    public static final SettingKey<Boolean> CHARACTER_NULLABLE = Keys.register("character.nullable", Boolean.class, false);
    public static final SettingKey<Boolean> COLLECTION_ELEMENTS_NULLABLE = Keys.register("collection.elements.nullable", Boolean.class, false);
    public static final SettingKey<Integer> COLLECTION_MIN_SIZE = Keys.register("collection.min.size", Integer.class, 2, MIN_ADJUSTER);
    public static final SettingKey<Integer> COLLECTION_MAX_SIZE = Keys.register("collection.max.size", Integer.class, 6, MAX_ADJUSTER);
    public static final SettingKey<Boolean> COLLECTION_NULLABLE = Keys.register("collection.nullable", Boolean.class, false);
    public static final SettingKey<Double> DOUBLE_MIN = Keys.register("double.min", Double.class, 1.0, MIN_ADJUSTER);
    public static final SettingKey<Double> DOUBLE_MAX = Keys.register("double.max", Double.class, 10000.0, MAX_ADJUSTER);
    public static final SettingKey<Boolean> DOUBLE_NULLABLE = Keys.register("double.nullable", Boolean.class, false);
    public static final SettingKey<Float> FLOAT_MIN = Keys.register("float.min", Float.class, Float.valueOf(1.0f), MIN_ADJUSTER);
    public static final SettingKey<Float> FLOAT_MAX = Keys.register("float.max", Float.class, Float.valueOf(10000.0f), MAX_ADJUSTER);
    public static final SettingKey<Boolean> FLOAT_NULLABLE = Keys.register("float.nullable", Boolean.class, false);
    public static final SettingKey<Integer> INTEGER_MIN = Keys.register("integer.min", Integer.class, 1, MIN_ADJUSTER);
    public static final SettingKey<Integer> INTEGER_MAX = Keys.register("integer.max", Integer.class, 10000, MAX_ADJUSTER);
    public static final SettingKey<Boolean> INTEGER_NULLABLE = Keys.register("integer.nullable", Boolean.class, false);
    public static final SettingKey<Long> LONG_MIN = Keys.register("long.min", Long.class, 1L, MIN_ADJUSTER);
    public static final SettingKey<Long> LONG_MAX = Keys.register("long.max", Long.class, 10000L, MAX_ADJUSTER);
    public static final SettingKey<Boolean> LONG_NULLABLE = Keys.register("long.nullable", Boolean.class, false);
    public static final SettingKey<Boolean> MAP_KEYS_NULLABLE = Keys.register("map.keys.nullable", Boolean.class, false);
    public static final SettingKey<Integer> MAP_MIN_SIZE = Keys.register("map.min.size", Integer.class, 2, MIN_ADJUSTER);
    public static final SettingKey<Integer> MAP_MAX_SIZE = Keys.register("map.max.size", Integer.class, 6, MAX_ADJUSTER);
    public static final SettingKey<Boolean> MAP_NULLABLE = Keys.register("map.nullable", Boolean.class, false);
    public static final SettingKey<Boolean> MAP_VALUES_NULLABLE = Keys.register("map.values.nullable", Boolean.class, false);
    public static final SettingKey<Integer> MAX_DEPTH = Keys.register("max.depth", Integer.class, 8);
    public static final SettingKey<Mode> MODE = Keys.register("mode", Mode.class, (Object)Mode.STRICT);
    @ExperimentalApi
    public static final SettingKey<OnSetFieldError> ON_SET_FIELD_ERROR = Keys.register("on.set.field.error", OnSetFieldError.class, (Object)OnSetFieldError.IGNORE);
    @ExperimentalApi
    public static final SettingKey<OnSetMethodError> ON_SET_METHOD_ERROR = Keys.register("on.set.method.error", OnSetMethodError.class, (Object)OnSetMethodError.ASSIGN_FIELD);
    @ExperimentalApi
    public static final SettingKey<OnSetMethodNotFound> ON_SET_METHOD_NOT_FOUND = Keys.register("on.set.method.not.found", OnSetMethodNotFound.class, (Object)OnSetMethodNotFound.ASSIGN_FIELD);
    public static final SettingKey<Boolean> OVERWRITE_EXISTING_VALUES = Keys.register("overwrite.existing.values", Boolean.class, true);
    public static final SettingKey<Long> SEED = Keys.register("seed", Long.class, null, null, true);
    @ExperimentalApi
    public static final SettingKey<Boolean> SET_BACK_REFERENCES = Keys.register("set.back.references", Boolean.class, false);
    @ExperimentalApi
    public static final SettingKey<Integer> SETTER_EXCLUDE_MODIFIER = Keys.register("setter.exclude.modifier", Integer.class, 0);
    @ExperimentalApi
    public static final SettingKey<SetterStyle> SETTER_STYLE = Keys.register("setter.style", SetterStyle.class, (Object)SetterStyle.SET);
    public static final SettingKey<Short> SHORT_MIN = Keys.register("short.min", Short.class, (short)1, MIN_ADJUSTER);
    public static final SettingKey<Short> SHORT_MAX = Keys.register("short.max", Short.class, (short)10000, MAX_ADJUSTER);
    public static final SettingKey<Boolean> SHORT_NULLABLE = Keys.register("short.nullable", Boolean.class, false);
    public static final SettingKey<Boolean> STRING_ALLOW_EMPTY = Keys.register("string.allow.empty", Boolean.class, false);
    public static final SettingKey<Boolean> STRING_FIELD_PREFIX_ENABLED = Keys.register("string.field.prefix.enabled", Boolean.class, false);
    public static final SettingKey<Integer> STRING_MIN_LENGTH = Keys.register("string.min.length", Integer.class, 3, MIN_ADJUSTER);
    public static final SettingKey<Integer> STRING_MAX_LENGTH = Keys.register("string.max.length", Integer.class, 10, MAX_ADJUSTER);
    public static final SettingKey<Boolean> STRING_NULLABLE = Keys.register("string.nullable", Boolean.class, false);
    private static final Map<String, SettingKey<?>> SETTING_KEY_MAP = Collections.unmodifiableMap(Keys.settingKeyMap());

    private static Map<String, SettingKey<?>> settingKeyMap() {
        HashMap map = new HashMap();
        for (SettingKey<Object> key : ALL_KEYS) {
            map.put(key.propertyKey(), key);
        }
        return map;
    }

    public static List<SettingKey<Object>> all() {
        return Collections.unmodifiableList(ALL_KEYS);
    }

    public static <T> SettingKey<T> get(@NotNull String key) {
        return SETTING_KEY_MAP.get(key);
    }

    @ExperimentalApi
    public static <T> SettingKey.SettingKeyBuilder<T> ofType(Class<T> type) {
        return InternalKey.builder(type);
    }

    private static <T> SettingKey<T> register(@NotNull String propertyKey, @NotNull Class<T> type, @Nullable Object defaultValue, @Nullable RangeAdjuster rangeAdjuster, boolean allowsNullValue) {
        InternalKey settingKey = new InternalKey(propertyKey, type, defaultValue, rangeAdjuster, allowsNullValue);
        ALL_KEYS.add(settingKey);
        return settingKey;
    }

    private static <T> SettingKey<T> register(@NotNull String propertyKey, @NotNull Class<T> type, @Nullable Object defaultValue, @Nullable RangeAdjuster rangeAdjuster) {
        return Keys.register(propertyKey, type, defaultValue, rangeAdjuster, false);
    }

    private static <T> SettingKey<T> register(@NotNull String key, @NotNull Class<T> type, @NotNull Object defaultValue) {
        return Keys.register(key, type, defaultValue, null, false);
    }

    private Keys() {
    }
}

