/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.generator;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import org.instancio.Instancio;
import org.instancio.Model;
import org.instancio.Random;
import org.instancio.Select;
import org.instancio.TargetSelector;
import org.instancio.generator.Generator;
import org.instancio.generator.GeneratorSpec;
import org.instancio.internal.RandomHelper;
import org.instancio.internal.util.ObjectUtils;
import org.instancio.internal.util.TypeUtils;
import org.instancio.settings.Keys;
import org.instancio.settings.Settings;
import org.instancio.support.Global;
import org.instancio.support.ThreadLocalSettings;

public interface ValueSpec<T>
extends GeneratorSpec<T> {
    default public T get() {
        Settings settings = ObjectUtils.defaultIfNull(ThreadLocalSettings.getInstance().get(), Global::getPropertiesFileSettings);
        Random random = RandomHelper.resolveRandom(settings.get(Keys.SEED), null);
        return ((Generator)((Object)this)).generate(random);
    }

    default public List<T> list(int size) {
        ArrayList<T> results = new ArrayList<T>(size);
        for (int i = 0; i < size; ++i) {
            results.add(this.get());
        }
        return results;
    }

    default public Stream<T> stream() {
        return Stream.generate(this::get);
    }

    default public <R> R map(Function<T, R> fn) {
        return fn.apply(this.get());
    }

    default public Model<T> toModel() {
        Class<?> typeArg = TypeUtils.getGenericSuperclassTypeArgument(this.getClass());
        return Instancio.of(typeArg).generate((TargetSelector)Select.all(typeArg), this).toModel();
    }

    public ValueSpec<T> nullable();
}

