/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal;

import java.util.Optional;
import java.util.function.Supplier;
import org.instancio.exception.InstancioTerminatingException;
import org.instancio.internal.context.ModelContext;
import org.instancio.internal.util.Fail;
import org.instancio.internal.util.Format;
import org.instancio.internal.util.SystemProperties;
import org.instancio.settings.Keys;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ErrorHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ErrorHandler.class);
    private static final String SUPPRESSION_REASON = String.format("Suppressed error because Keys.FAIL_ON_ERROR (%s) is disabled.%n -> To propagate the error, set Keys.FAIL_ON_ERROR setting to true. %n -> To display the stack trace, run in verbose() mode or with TRACE logging.%n", Keys.FAIL_ON_ERROR.propertyKey());
    private final ModelContext<?> context;
    private final boolean isFailOnErrorSettingEnabled;

    ErrorHandler(ModelContext<?> context) {
        this.context = context;
        this.isFailOnErrorSettingEnabled = context.getSettings().get(Keys.FAIL_ON_ERROR);
    }

    public <T> Optional<T> conditionalFailOnError(Supplier<T> supplier) {
        try {
            return Optional.ofNullable(supplier.get());
        }
        catch (AssertionError | InstancioTerminatingException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            if (this.isShouldFailOnError()) {
                throw Fail.withInternalError(ex);
            }
            this.logSuppressed(ex);
            return Optional.empty();
        }
    }

    private boolean isShouldFailOnError() {
        return this.isFailOnErrorSettingEnabled || SystemProperties.isFailOnErrorEnabled();
    }

    private void logSuppressed(Throwable t) {
        if (this.context.isVerbose()) {
            String errorMsg = String.format("Exception occurred while generating the root object of type %s.%nPrinting stacktrace because verbose() mode is enabled.%nTo propagate internal errors, set Keys.FAIL_ON_ERROR setting to true.%n", Format.withoutPackage(this.context.getRootType()));
            System.err.println(errorMsg);
            t.printStackTrace();
        } else if (LOG.isTraceEnabled()) {
            LOG.trace(SUPPRESSION_REASON, t);
        } else {
            LOG.debug("{}\n{}: {}", new Object[]{SUPPRESSION_REASON, t.getClass().getName(), t.getMessage()});
        }
    }
}

