/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.domain.id.pol;

import java.util.List;
import org.instancio.generator.GeneratorContext;
import org.instancio.internal.generator.checksum.BaseModCheckGenerator;
import org.instancio.internal.util.NumberUtils;

abstract class WeightsModCheckGenerator
extends BaseModCheckGenerator {
    protected WeightsModCheckGenerator(GeneratorContext context) {
        super(context);
    }

    protected abstract List<Integer> weights();

    @Override
    protected int payloadLength() {
        return this.weights().size();
    }

    @Override
    protected char getCheckDigit(String payload) {
        int result = this.modulo(payload);
        if (result == 10) {
            return '0';
        }
        return NumberUtils.toDigitChar(result);
    }

    @Override
    protected int modulo(String payload) {
        int sum = 0;
        for (int i = 0; i < payload.length(); ++i) {
            int n = NumberUtils.toDigitInt(payload.charAt(i));
            sum += (n *= this.weights().get(i).intValue());
        }
        return sum % this.base();
    }

    @Override
    protected int base() {
        return 11;
    }
}

